/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.asm;

import java.util.Arrays;
import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapper;
import org.sfm.reflect.Instantiator;

public class MapperKey<K extends FieldKey<K>> {
    private final K[] keys;
    private final Class<?>[] fieldMappers;
    private final Class<?>[] constructorFieldMappers;
    private final Class<?> instantiator;
    private final Class<?> target;

    public MapperKey(K[] keys, FieldMapper<?, ?>[] fieldMappers, FieldMapper<?, ?>[] constructorFieldMappers, Instantiator<?, ?> instantiator, Class<?> target) {
        this.keys = keys;
        this.fieldMappers = this.getClassArray(fieldMappers);
        this.constructorFieldMappers = this.getClassArray(constructorFieldMappers);
        this.instantiator = this.getClass(instantiator);
        this.target = target;
    }

    private Class<?>[] getClassArray(Object[] objects) {
        Class[] classes = new Class[objects != null ? objects.length : 0];
        if (objects != null) {
            int i = 0;
            for (Object o : objects) {
                classes[i] = this.getClass(o);
                ++i;
            }
        }
        return classes;
    }

    private Class<?> getClass(Object o) {
        if (o != null) {
            return o.getClass();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapperKey that = (MapperKey)o;
        if (!Arrays.equals(this.keys, that.keys)) {
            return false;
        }
        if (!Arrays.equals(this.fieldMappers, that.fieldMappers)) {
            return false;
        }
        if (!Arrays.equals(this.constructorFieldMappers, that.constructorFieldMappers)) {
            return false;
        }
        if (this.instantiator != null ? !this.instantiator.equals(that.instantiator) : that.instantiator != null) {
            return false;
        }
        return !(this.target == null ? that.target != null : !this.target.equals(that.target));
    }

    public int hashCode() {
        int result = this.keys != null ? Arrays.hashCode(this.keys) : 0;
        result = 31 * result + (this.fieldMappers != null ? Arrays.hashCode(this.fieldMappers) : 0);
        result = 31 * result + (this.constructorFieldMappers != null ? Arrays.hashCode(this.constructorFieldMappers) : 0);
        result = 31 * result + (this.instantiator != null ? this.instantiator.hashCode() : 0);
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        return result;
    }
}

