/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.asm.AsmUtils;

public class InstantiatorBuilder {
    public static <S> byte[] createInstantiator(String className, Class<?> sourceClass, InstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class<?> targetClass = instantiatorDefinition.getExecutable().getDeclaringClass();
        String targetType = AsmUtils.toType(targetClass);
        String sourceType = AsmUtils.toWrapperType(sourceClass);
        String classType = AsmUtils.toType(className);
        String instantiatorType = AsmUtils.toType(Instantiator.class);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + instantiatorType + "<L" + targetType + ";>;", "java/lang/Object", new String[]{instantiatorType});
        Parameter[] parameters = instantiatorDefinition.getParameters();
        for (Map.Entry<Parameter, Getter<S, ?>> entry : injections.entrySet()) {
            FieldVisitor fv = cw.visitField(16, "getter_" + entry.getKey().getName(), "L" + AsmUtils.toType(entry.getValue().getClass()) + ";", null, null);
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/util/Map;)V", "(Ljava/util/Map<Ljava.lang.String;L" + AsmUtils.toType(Getter.class) + "<" + AsmUtils.toDeclaredLType(sourceType) + "*>;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        for (Map.Entry<Parameter, Getter<S, ?>> entry : injections.entrySet()) {
            String name = entry.getKey().getName();
            String getterType = AsmUtils.toType(entry.getValue().getClass());
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)name);
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, getterType);
            mv.visitFieldInsn(181, classType, "getter_" + name, "L" + getterType + ";");
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "newInstance", "(" + AsmUtils.toDeclaredLType(sourceType) + ")L" + targetType + ";", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitTypeInsn(187, targetType);
        mv.visitInsn(89);
        StringBuilder sb = new StringBuilder();
        for (Parameter p : parameters) {
            Getter<S, ?> getter = injections.get(p);
            String propertyType = AsmUtils.toType(p.getType());
            if (TypeHelper.isPrimitive(p.getType())) {
                sb.append(propertyType);
            } else if (TypeHelper.isArray(p.getType())) {
                sb.append(propertyType);
            } else {
                sb.append("L").append(propertyType).append(";");
            }
            if (getter == null) {
                if (TypeHelper.isPrimitive(p.getType())) {
                    mv.visitInsn(AsmUtils.defaultValue.get(p.getType()).intValue());
                    continue;
                }
                mv.visitInsn(1);
                continue;
            }
            Class<?> getterPublicType = AsmUtils.getPublicOrInterfaceClass(getter.getClass());
            String getterType = AsmUtils.toType(getterPublicType);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, classType, "getter_" + p.getName(), "L" + getterType + ";");
            mv.visitVarInsn(25, 1);
            if (TypeHelper.isPrimitive(p.getType())) {
                String methodSuffix = AsmUtils.wrappers.get(p.getType()).getSimpleName();
                if ("Integer".equals(methodSuffix)) {
                    methodSuffix = "Int";
                }
                String methodName = "get" + methodSuffix;
                try {
                    getterPublicType.getMethod(methodName, new Class[0]);
                    AsmUtils.invoke(mv, getterPublicType, "get" + methodSuffix, "(" + AsmUtils.toDeclaredLType(sourceType) + ")" + propertyType);
                }
                catch (NoSuchMethodException e) {
                    if (AsmUtils.isStillGeneric(getter.getClass())) {
                        AsmUtils.invoke(mv, getterPublicType, "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
                        mv.visitTypeInsn(192, AsmUtils.toWrapperType(p.getType()));
                    } else {
                        AsmUtils.invoke(mv, getterPublicType, "get", "(" + AsmUtils.toDeclaredLType(sourceType) + ")L" + AsmUtils.toType(getter.getClass().getMethod("get", sourceClass).getReturnType()) + ";");
                    }
                    String valueMethodPrefix = methodSuffix.toLowerCase();
                    if ("character".equals(valueMethodPrefix)) {
                        valueMethodPrefix = "char";
                    }
                    String valueMethod = valueMethodPrefix + "Value";
                    AsmUtils.invoke(mv, AsmUtils.toWrapperClass(p.getType()), valueMethod, "()" + AsmUtils.toType(p.getType()));
                }
                continue;
            }
            if (AsmUtils.isStillGeneric(getter.getClass())) {
                AsmUtils.invoke(mv, getterPublicType, "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
                mv.visitTypeInsn(192, propertyType);
                continue;
            }
            AsmUtils.invoke(mv, getterPublicType, "get", "(" + AsmUtils.toDeclaredLType(sourceType) + ")L" + AsmUtils.toType(getter.getClass().getMethod("get", sourceClass).getReturnType()) + ";");
        }
        Member member = instantiatorDefinition.getExecutable();
        if (member instanceof Constructor) {
            mv.visitMethodInsn(183, targetType, "<init>", "(" + sb.toString() + ")V", false);
        } else {
            mv.visitMethodInsn(184, targetType, member.getName(), AsmUtils.toSignature((Method)member), false);
        }
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "newInstance", "(Ljava/lang/Object;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, sourceType);
        mv.visitMethodInsn(182, classType, "newInstance", "(" + AsmUtils.toDeclaredLType(sourceType) + ")L" + targetType + ";", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitMethodInsn(182, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn((Object)"{");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        for (int i = 0; i < parameters.length; ++i) {
            String string = (i > 0 ? ", " : "") + "parameter" + i + "=";
            String parameter = String.valueOf(parameters[i]);
            mv.visitLdcInsn((Object)string);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn((Object)parameter);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            Getter<S, ?> getter = injections.get(parameters[i]);
            String getterName = ", parameter" + i + "=";
            String getterString = String.valueOf(getter);
            mv.visitLdcInsn((Object)getterName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn((Object)getterString);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        mv.visitLdcInsn((Object)"}");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }
}

