/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.asm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.asm.AsmUtils;
import org.sfm.utils.ErrorHelper;

public class AsmInstantiatorDefinitionFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<InstantiatorDefinition> extractDefinitions(final Type target) throws IOException {
        final ArrayList<InstantiatorDefinition> constructors = new ArrayList<InstantiatorDefinition>();
        final Class targetClass = TypeHelper.toClass(target);
        ClassLoader cl = targetClass.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        String fileName = targetClass.getName().replace('.', '/') + ".class";
        InputStream is = cl.getResourceAsStream(fileName);
        try {
            if (is == null) {
                throw new IOException("Cannot find file " + fileName + " in " + cl);
            }
            ClassReader classReader = new ClassReader(is);
            classReader.accept(new ClassVisitor(327680){
                List<String> genericTypeNames;

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.genericTypeNames = signature != null ? AsmUtils.extractGenericTypeNames(signature) : Collections.emptyList();
                    super.visit(version, access, name, signature, superName, interfaces);
                }

                public MethodVisitor visitMethod(int access, final String methodName, String desc, String signature, String[] exceptions) {
                    final boolean isConstructor = "<init>".equals(methodName);
                    if ((1 & access) == 1 && (isConstructor || (8 & access) == 8 && !desc.endsWith("V"))) {
                        List<String> genericTypes;
                        ArrayList names;
                        List<String> descTypes;
                        block6: {
                            descTypes = AsmUtils.extractTypeNames(desc);
                            names = new ArrayList();
                            genericTypes = signature != null ? AsmUtils.extractTypeNames(signature) : descTypes;
                            if (!isConstructor) {
                                if (descTypes.size() > 0) {
                                    try {
                                        Type genericType = AsmUtils.toGenericType(descTypes.get(descTypes.size() - 1), this.genericTypeNames, target);
                                        if (!targetClass.isAssignableFrom(TypeHelper.toClass(genericType))) {
                                            return null;
                                        }
                                        break block6;
                                    }
                                    catch (ClassNotFoundException e) {
                                        return null;
                                    }
                                }
                                return null;
                            }
                        }
                        return new MethodVisitor(327680){
                            Label firstLabel;
                            Label lastLabel;

                            public void visitLabel(Label label) {
                                if (this.firstLabel == null) {
                                    this.firstLabel = label;
                                }
                                this.lastLabel = label;
                            }

                            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                                if (start.equals(this.firstLabel) && end.equals(this.lastLabel) && !"this".equals(name)) {
                                    names.add(name);
                                }
                            }

                            public void visitEnd() {
                                try {
                                    ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                                    int l = descTypes.size() - (isConstructor ? 0 : 1);
                                    for (int i = 0; i < l; ++i) {
                                        String name = "arg" + i;
                                        if (i < names.size()) {
                                            name = (String)names.get(i);
                                        }
                                        parameters.add(this.createParameter(name, (String)descTypes.get(i), (String)genericTypes.get(i)));
                                    }
                                    Executable executable = isConstructor ? targetClass.getDeclaredConstructor(this.toTypeArray(parameters)) : targetClass.getDeclaredMethod(methodName, this.toTypeArray(parameters));
                                    constructors.add(new InstantiatorDefinition(executable, parameters.toArray(new Parameter[parameters.size()])));
                                }
                                catch (Exception e) {
                                    ErrorHelper.rethrow(e);
                                }
                            }

                            private Class<?>[] toTypeArray(List<Parameter> parameters) {
                                Class[] types = new Class[parameters.size()];
                                for (int i = 0; i < types.length; ++i) {
                                    types[i] = parameters.get(i).getType();
                                }
                                return types;
                            }

                            private Parameter createParameter(String name, String desc, String signature) {
                                try {
                                    Type basicType;
                                    Type genericType = basicType = AsmUtils.toGenericType(desc, genericTypeNames, target);
                                    if (signature != null) {
                                        genericType = AsmUtils.toGenericType(signature, genericTypeNames, target);
                                    }
                                    return new Parameter(name, TypeHelper.toClass(basicType), genericType);
                                }
                                catch (ClassNotFoundException e) {
                                    throw new Error("Unexpected error " + e, e);
                                }
                            }
                        };
                    }
                    return null;
                }
            }, 0);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        return constructors;
    }
}

