/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.sfm.reflect.Getter;
import org.sfm.reflect.GetterHelper;
import org.sfm.reflect.asm.AsmFactory;
import org.sfm.reflect.impl.FieldGetter;
import org.sfm.reflect.impl.MethodGetter;
import org.sfm.reflect.primitive.BooleanGetter;
import org.sfm.reflect.primitive.BoxedBooleanGetter;
import org.sfm.reflect.primitive.BoxedByteGetter;
import org.sfm.reflect.primitive.BoxedCharacterGetter;
import org.sfm.reflect.primitive.BoxedDoubleGetter;
import org.sfm.reflect.primitive.BoxedFloatGetter;
import org.sfm.reflect.primitive.BoxedIntGetter;
import org.sfm.reflect.primitive.BoxedLongGetter;
import org.sfm.reflect.primitive.BoxedShortGetter;
import org.sfm.reflect.primitive.ByteGetter;
import org.sfm.reflect.primitive.CharacterGetter;
import org.sfm.reflect.primitive.DoubleGetter;
import org.sfm.reflect.primitive.FloatGetter;
import org.sfm.reflect.primitive.IntGetter;
import org.sfm.reflect.primitive.LongGetter;
import org.sfm.reflect.primitive.ShortGetter;

public final class ObjectGetterFactory {
    private final AsmFactory asmFactory;

    public ObjectGetterFactory(AsmFactory asmFactory) {
        this.asmFactory = asmFactory;
    }

    public <T, P> Getter<T, P> getGetter(Class<? super T> target, String property) {
        Method method = this.lookForMethod(target, property);
        Getter<T, P> getter = method == null ? this.getFieldGetter(target, property) : this.getMethodGetter(method);
        return getter;
    }

    public <T, P> Getter<T, P> getMethodGetter(Method method) {
        if (this.asmFactory != null) {
            try {
                return this.asmFactory.createGetter(method);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new MethodGetter(method);
    }

    public <T, P> Getter<T, P> getFieldGetter(Class<?> target, String property) {
        Field field = this.lookForField(target, property);
        if (field != null) {
            return this.getFieldGetter(field);
        }
        return null;
    }

    private <T, P> Getter<T, P> getFieldGetter(Field field) {
        if (this.asmFactory != null && Modifier.isPublic(field.getModifiers())) {
            try {
                return this.asmFactory.createGetter(field);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
        return new FieldGetter(field);
    }

    private Method lookForMethod(Class<?> target, String property) {
        if (target == null) {
            return null;
        }
        for (Method m : target.getDeclaredMethods()) {
            if (!GetterHelper.methodModifiersMatches(m.getModifiers()) || !GetterHelper.methodNameMatchesProperty(m.getName(), property)) continue;
            return m;
        }
        if (!Object.class.equals(target)) {
            return this.lookForMethod(target.getSuperclass(), property);
        }
        return null;
    }

    private Field lookForField(Class<?> target, String property) {
        if (target == null) {
            return null;
        }
        for (Field field : target.getDeclaredFields()) {
            if (!GetterHelper.fieldModifiersMatches(field.getModifiers()) || !GetterHelper.fieldNameMatchesProperty(field.getName(), property)) continue;
            return field;
        }
        return this.lookForField(target.getSuperclass(), property);
    }

    public static <T, P> BooleanGetter<T> toBooleanGetter(Getter<? super T, ? extends P> getter) {
        if (getter instanceof BooleanGetter) {
            return (BooleanGetter)((Object)getter);
        }
        return new BoxedBooleanGetter<T>(getter);
    }

    public static <T, P> IntGetter<T> toIntGetter(Getter<? super T, ? extends P> getter) {
        if (getter instanceof IntGetter) {
            return (IntGetter)((Object)getter);
        }
        return new BoxedIntGetter<T>(getter);
    }

    public static <T, P> LongGetter<T> toLongGetter(Getter<? super T, ? extends P> getter) {
        if (getter instanceof LongGetter) {
            return (LongGetter)((Object)getter);
        }
        return new BoxedLongGetter<T>(getter);
    }

    public static <T, P> FloatGetter<T> toFloatGetter(Getter<? super T, ? extends P> getter) {
        if (getter instanceof FloatGetter) {
            return (FloatGetter)((Object)getter);
        }
        return new BoxedFloatGetter<T>(getter);
    }

    public static <T, P> DoubleGetter<T> toDoubleGetter(Getter<? super T, ? extends P> getter) {
        if (getter instanceof DoubleGetter) {
            return (DoubleGetter)((Object)getter);
        }
        return new BoxedDoubleGetter<T>(getter);
    }

    public static <T, P> ByteGetter<T> toByteGetter(Getter<? super T, ? extends P> getter) {
        if (getter instanceof ByteGetter) {
            return (ByteGetter)((Object)getter);
        }
        return new BoxedByteGetter<T>(getter);
    }

    public static <T, P> ShortGetter<T> toShortGetter(Getter<? super T, ? extends P> getter) {
        if (getter instanceof ShortGetter) {
            return (ShortGetter)((Object)getter);
        }
        return new BoxedShortGetter<T>(getter);
    }

    public static <T, P> CharacterGetter<T> toCharGetter(Getter<? super T, ? extends P> getter) {
        if (getter instanceof CharacterGetter) {
            return (CharacterGetter)((Object)getter);
        }
        return new BoxedCharacterGetter<T>(getter);
    }
}

