/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sfm.map.ColumnDefinition;
import org.sfm.map.FieldKey;
import org.sfm.map.GetterFactory;
import org.sfm.map.impl.CalculateMaxIndex;
import org.sfm.map.impl.PropertyMapping;
import org.sfm.map.impl.PropertyMappingsBuilder;
import org.sfm.reflect.Getter;
import org.sfm.reflect.GetterInstantiator;
import org.sfm.reflect.IdentityGetter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.asm.AsmFactory;
import org.sfm.reflect.impl.EmptyConstructorInstantiator;
import org.sfm.reflect.impl.EmptyStaticMethodInstantiator;
import org.sfm.reflect.impl.InjectConstructorInstantiator;
import org.sfm.reflect.impl.InjectStaticMethodInstantiator;
import org.sfm.utils.ForEachCallBack;

public class InstantiatorFactory {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final AsmFactory asmFactory;

    public InstantiatorFactory(AsmFactory asmFactory) {
        this.asmFactory = asmFactory;
    }

    public <S, T, K extends FieldKey<K>, D extends ColumnDefinition<K, D>> Instantiator<S, T> getInstantiator(Type source, Type target, PropertyMappingsBuilder<T, K, D> propertyMappingsBuilder, Map<Parameter, Getter<? super S, ?>> constructorParameterGetterMap, GetterFactory<? super S, K> getterFactory) throws NoSuchMethodException {
        return this.getInstantiator(source, target, propertyMappingsBuilder, constructorParameterGetterMap, getterFactory, true);
    }

    public <S, T, K extends FieldKey<K>, D extends ColumnDefinition<K, D>> Instantiator<S, T> getInstantiator(Type source, Type target, PropertyMappingsBuilder<T, K, D> propertyMappingsBuilder, Map<Parameter, Getter<? super S, ?>> constructorParameterGetterMap, final GetterFactory<? super S, K> getterFactory, boolean useAsmIfEnabled) throws NoSuchMethodException {
        if (propertyMappingsBuilder.isDirectProperty()) {
            Getter getter = (propertyMappingsBuilder.forEachProperties((ForEachCallBack)new ForEachCallBack<PropertyMapping<T, ?, K, D>>(){
                public Getter getter;

                @Override
                public void handle(PropertyMapping<T, ?, K, D> propertyMapping) {
                    this.getter = getterFactory.newGetter(propertyMapping.getPropertyMeta().getPropertyType(), propertyMapping.getColumnKey(), propertyMapping.getColumnDefinition());
                }
            })).getter;
            return new GetterInstantiator(getter);
        }
        if (TypeHelper.isArray(target)) {
            return this.getArrayInstantiator(TypeHelper.toClass(TypeHelper.getComponentTypeOfListOrArray(target)), ((CalculateMaxIndex)propertyMappingsBuilder.forEachProperties((ForEachCallBack)new CalculateMaxIndex())).maxIndex + 1);
        }
        return this.getInstantiator(target, TypeHelper.toClass(source), propertyMappingsBuilder.getPropertyFinder().getEligibleInstantiatorDefinitions(), constructorParameterGetterMap, useAsmIfEnabled);
    }

    public <S, T> Instantiator<S, T> getInstantiator(Type target, Class<?> source, List<InstantiatorDefinition> constructors, Map<Parameter, Getter<? super S, ?>> injections, boolean useAsmIfEnabled) throws SecurityException {
        InstantiatorDefinition instantiatorDefinition = this.getSmallerConstructor(constructors);
        if (instantiatorDefinition == null) {
            throw new IllegalArgumentException("No constructor available for " + target);
        }
        return this.newInstantiator(source, injections, useAsmIfEnabled, instantiatorDefinition);
    }

    private <S, T> Instantiator<S, T> newInstantiator(Class<?> source, Map<Parameter, Getter<? super S, ?>> injections, boolean useAsmIfEnabled, InstantiatorDefinition instantiatorDefinition) {
        Member executable = instantiatorDefinition.getExecutable();
        if (this.asmFactory != null && Modifier.isPublic(executable.getModifiers()) && useAsmIfEnabled) {
            try {
                return this.asmFactory.createInstantiator(source, instantiatorDefinition, injections);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (executable instanceof Constructor) {
            Constructor c = (Constructor)executable;
            if (c.getParameterTypes().length == 0) {
                return new EmptyConstructorInstantiator(c);
            }
            return new InjectConstructorInstantiator(instantiatorDefinition, injections);
        }
        if (executable instanceof Method) {
            Method m = (Method)executable;
            if (m.getParameterTypes().length == 0) {
                return new EmptyStaticMethodInstantiator(m);
            }
            return new InjectStaticMethodInstantiator(instantiatorDefinition, injections);
        }
        throw new IllegalArgumentException("Unsupported executable type " + executable);
    }

    private InstantiatorDefinition getSmallerConstructor(List<InstantiatorDefinition> constructors) {
        if (constructors == null) {
            return null;
        }
        InstantiatorDefinition selectedConstructor = null;
        for (InstantiatorDefinition c : constructors) {
            if (selectedConstructor != null && c.compareTo(selectedConstructor) >= 0) continue;
            selectedConstructor = c;
        }
        return selectedConstructor;
    }

    public <S, T> Instantiator<S, T> getArrayInstantiator(Class<?> elementType, int length) {
        return new ArrayInstantiator(elementType, length);
    }

    public <S, T> Instantiator<S, T> getOneArgIdentityInstantiator(InstantiatorDefinition id) {
        HashMap injections = new HashMap();
        injections.put(id.getParameters()[0], new IdentityGetter());
        return this.newInstantiator(id.getParameters()[0].getType(), injections, true, id);
    }

    private static final class ArrayInstantiator<S, T>
    implements Instantiator<S, T> {
        private final Class<?> elementType;
        private final int length;

        public ArrayInstantiator(Class<?> elementType, int length) {
            this.elementType = elementType;
            this.length = length;
        }

        @Override
        public T newInstance(S s) throws Exception {
            return (T)Array.newInstance(this.elementType, this.length);
        }
    }
}

