/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.context;

import java.util.List;
import org.sfm.map.impl.context.KeySourceGetter;
import org.sfm.utils.ErrorHelper;

public class KeysDefinition<S, K> {
    private final KeySourceGetter<K, S> keySourceGetter;
    private final List<K> keys;
    private final int parentIndex;

    public KeysDefinition(List<K> keys, KeySourceGetter<K, S> keySourceGetter, int parentIndex) {
        this.keys = keys;
        this.keySourceGetter = keySourceGetter;
        this.parentIndex = parentIndex;
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public Object[] getValues(S source) {
        try {
            Object[] values = new Object[this.keys.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.keySourceGetter.getValue(this.keys.get(i), source);
            }
            return values;
        }
        catch (Exception e) {
            return (Object[])ErrorHelper.rethrow(e);
        }
    }

    public int getParentIndex() {
        return this.parentIndex;
    }
}

