/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import org.sfm.map.FieldKey;
import org.sfm.map.impl.MapperKey;
import org.sfm.map.impl.TypeAffinity;
import org.sfm.utils.Asserts;

public class JdbcColumnKey
implements FieldKey<JdbcColumnKey>,
TypeAffinity {
    public static final int UNDEFINED_TYPE = -99999;
    private final String name;
    private final int index;
    private final int sqlType;
    private final JdbcColumnKey parent;

    public JdbcColumnKey(String columnName, int columnIndex) {
        this.name = Asserts.requireNonNull("columnName", columnName);
        this.index = columnIndex;
        this.sqlType = -99999;
        this.parent = null;
    }

    public JdbcColumnKey(String columnName, int columnIndex, int sqlType) {
        this.name = Asserts.requireNonNull("columnName", columnName);
        this.index = columnIndex;
        this.sqlType = sqlType;
        this.parent = null;
    }

    public JdbcColumnKey(String columnName, int columnIndex, int sqlType, JdbcColumnKey parent) {
        this.name = Asserts.requireNonNull("columnName", columnName);
        this.index = columnIndex;
        this.sqlType = sqlType;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public JdbcColumnKey getParent() {
        return this.parent;
    }

    public String toString() {
        return "ColumnKey [columnName=" + this.name + ", columnIndex=" + this.index + ", sqlType=" + this.sqlType + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.sqlType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcColumnKey other = (JdbcColumnKey)obj;
        if (this.index != other.index) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.sqlType == other.sqlType;
    }

    @Override
    public JdbcColumnKey alias(String alias) {
        return new JdbcColumnKey(alias, this.index, this.sqlType, this);
    }

    public static JdbcColumnKey of(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return new JdbcColumnKey(metaData.getColumnLabel(columnIndex), columnIndex, metaData.getColumnType(columnIndex));
    }

    public static MapperKey<JdbcColumnKey> mapperKey(ResultSetMetaData metaData) throws SQLException {
        FieldKey[] keys = new JdbcColumnKey[metaData.getColumnCount()];
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            keys[i - 1] = JdbcColumnKey.of(metaData, i);
        }
        return new MapperKey(keys);
    }

    public Class<?>[] getAffinities() {
        switch (this.sqlType) {
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return new Class[]{String.class};
            }
            case -5: {
                return new Class[]{Long.class, Integer.class, Number.class};
            }
            case 4: 
            case 5: {
                return new Class[]{Integer.class, Long.class, Number.class};
            }
            case 3: 
            case 8: {
                return new Class[]{Double.class, Float.class, Number.class};
            }
            case 6: {
                return new Class[]{Float.class, Double.class, Number.class};
            }
            case 2: {
                return new Class[]{Double.class, Long.class, Number.class};
            }
            case 16: {
                return new Class[]{Boolean.class, Integer.class, Long.class, Number.class};
            }
            case 91: 
            case 92: 
            case 93: {
                return new Class[]{Date.class, Long.class};
            }
        }
        return null;
    }
}

