/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.parser;

import org.sfm.csv.parser.AbstractCsvCharConsumer;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.csv.parser.CharBuffer;

public final class StandardCsvCharConsumer
extends AbstractCsvCharConsumer {
    public StandardCsvCharConsumer(CharBuffer csvBuffer) {
        super(csvBuffer);
    }

    @Override
    protected void consumeOneChar(char character, int index, CellConsumer cellConsumer) {
        switch (character) {
            case ',': {
                this.newCellIfNotInQuote(index, cellConsumer);
                break;
            }
            case '\n': {
                this.handleEndOfLineLF(index, cellConsumer);
                break;
            }
            case '\r': {
                this.handleEndOfLineCR(index, cellConsumer);
                return;
            }
            case '\"': {
                this.quote(index);
                break;
            }
        }
        this.turnOffCrFlag();
    }

    @Override
    public boolean nextRow(CellConsumer cellConsumer) {
        int bufferLength = this.csvBuffer.getBufferLength();
        for (int index = this._currentIndex; index < bufferLength; ++index) {
            char character = this.csvBuffer.getChar(index);
            switch (character) {
                case ',': {
                    this.newCellIfNotInQuote(index, cellConsumer);
                    break;
                }
                case '\n': {
                    if (!this.handleEndOfLineLF(index, cellConsumer)) break;
                    this._currentIndex = index + 1;
                    this.turnOffCrFlag();
                    return true;
                }
                case '\r': {
                    if (!this.handleEndOfLineCR(index, cellConsumer)) break;
                    this._currentIndex = index + 1;
                    return true;
                }
                case '\"': {
                    this.quote(index);
                    break;
                }
            }
            this.turnOffCrFlag();
        }
        this._currentIndex = bufferLength;
        return false;
    }

    @Override
    public char quoteChar() {
        return '\"';
    }
}

