/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.parser;

import java.io.IOException;
import java.io.Reader;

public final class CharBuffer {
    private char[] buffer;
    private int bufferLength;
    private int mark;

    public CharBuffer(int bufferSize) {
        this.buffer = new char[bufferSize];
    }

    public void mark(int index) {
        this.mark = index;
    }

    public boolean fillBuffer(Reader reader) throws IOException {
        int length = reader.read(this.buffer, this.bufferLength, this.buffer.length - this.bufferLength);
        if (length != -1) {
            this.bufferLength += length;
            return true;
        }
        return false;
    }

    public int shiftBufferToMark() {
        int newLength = Math.max(this.bufferLength - this.mark, 0);
        if (newLength <= this.bufferLength >> 1) {
            System.arraycopy(this.buffer, this.mark, this.buffer, 0, newLength);
        } else {
            char[] newBuffer = new char[this.buffer.length << 1];
            System.arraycopy(this.buffer, this.mark, newBuffer, 0, newLength);
            this.buffer = newBuffer;
        }
        this.bufferLength = newLength;
        int m = this.mark;
        this.mark = 0;
        return m;
    }

    public char[] getCharBuffer() {
        return this.buffer;
    }

    public int getMark() {
        return this.mark;
    }

    public char getChar(int bufferIndex) {
        return this.buffer[bufferIndex];
    }

    public int getBufferLength() {
        return this.bufferLength;
    }
}

