/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.simpleflatmapper.reflect.meta.AnnotationToPropertyService;
import org.simpleflatmapper.reflect.meta.AnnotationToPropertyServiceProducer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ProducerServiceLoader;

public final class AnnotationToPropertyUtil {
    private static final AnnotationToPropertyService ANNOTATION_TO_PROPERTY_SERVICE = AnnotationToPropertyUtil.findAnnotationToProperty();

    private AnnotationToPropertyUtil() {
    }

    private static AnnotationToPropertyService findAnnotationToProperty() {
        final ArrayList providers = new ArrayList();
        ProducerServiceLoader.produceFromServiceLoader(ServiceLoader.load(AnnotationToPropertyServiceProducer.class), (Consumer)new Consumer<AnnotationToPropertyService>(){

            public void accept(AnnotationToPropertyService t) {
                providers.add(t);
            }
        });
        return AnnotationToPropertyUtil.aggregateAnnotationToProperty(providers.toArray(new AnnotationToPropertyService[0]));
    }

    public static AnnotationToPropertyService getAnnotationToPropertyService() {
        return ANNOTATION_TO_PROPERTY_SERVICE;
    }

    private static AnnotationToPropertyService aggregateAnnotationToProperty(AnnotationToPropertyService[] registered) {
        if (registered.length == 0) {
            return new DefaultAnnotationToPropertyService();
        }
        if (registered.length == 1) {
            return registered[0];
        }
        return new ArrayAnnotationToPropertyService(registered);
    }

    private static class DefaultAnnotationToPropertyService
    implements AnnotationToPropertyService {
        private DefaultAnnotationToPropertyService() {
        }

        @Override
        public void generateProperty(Annotation annotation, Consumer<Object> consumer) {
        }
    }

    private static class ArrayAnnotationToPropertyService
    implements AnnotationToPropertyService {
        private final AnnotationToPropertyService[] registered;

        public ArrayAnnotationToPropertyService(AnnotationToPropertyService[] registered) {
            this.registered = registered;
        }

        @Override
        public void generateProperty(Annotation annotation, Consumer<Object> consumer) {
            for (AnnotationToPropertyService atp : this.registered) {
                atp.generateProperty(annotation, consumer);
            }
        }
    }
}

