/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.getter;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.util.TypeHelper;

public class GetterFactoryRegistry<S, K> {
    private final Map<Class<?>, GetterFactory<S, K>> factoryPerType = new HashMap();

    public final void put(Class<?> target, GetterFactory<S, K> getterFactory) {
        this.factoryPerType.put(target, getterFactory);
    }

    public final GetterFactory<S, K> findFactoryFor(Type targetType) {
        Class target = TypeHelper.toClass((Type)targetType);
        GetterFactory<S, K> getterFactory = this.factoryPerType.get(target);
        if (getterFactory != null) {
            return getterFactory;
        }
        return null;
    }

    public void mapFromTo(Class<?> target, Class<?> source) {
        GetterFactory<S, K> getterFactory = this.factoryPerType.get(source);
        if (getterFactory == null) {
            throw new IllegalStateException("No getter factory defined for " + String.valueOf(source));
        }
        this.put(target, getterFactory);
    }
}

