/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.IntFactory;

public class ArrayElementPropertyMeta<T, E>
extends PropertyMeta<T, E> {
    private final int index;
    private final ArrayClassMeta<T, E> arrayMetaData;
    private final IntFactory<Setter<T, E>> setterFactory;
    private final IntFactory<Getter<T, E>> getterFactory;

    public ArrayElementPropertyMeta(String name, Type ownerType, ReflectionService reflectService, int index, ArrayClassMeta<T, E> arrayMetaData, IntFactory<Setter<T, E>> setterFactory, IntFactory<Getter<T, E>> getterFactory) {
        super(name, ownerType, reflectService);
        if (index < 0) {
            throw new IllegalArgumentException("Invalid array index " + index);
        }
        this.index = index;
        this.arrayMetaData = arrayMetaData;
        this.setterFactory = setterFactory;
        this.getterFactory = getterFactory;
    }

    @Override
    public Setter<T, E> getSetter() {
        return (Setter)this.setterFactory.newInstance(this.index);
    }

    @Override
    public Getter<T, E> getGetter() {
        return (Getter)this.getterFactory.newInstance(this.index);
    }

    @Override
    public Type getPropertyType() {
        return this.arrayMetaData.getElementTarget();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getPath() {
        return "[" + this.index + "]";
    }

    @Override
    public PropertyMeta<T, E> withReflectionService(ReflectionService reflectionService) {
        return new ArrayElementPropertyMeta<T, E>(this.getName(), this.getOwnerType(), reflectionService, this.index, this.arrayMetaData.withReflectionService(reflectionService), this.setterFactory, this.getterFactory);
    }

    public String toString() {
        return "ArrayElementPropertyMeta{index=" + this.index + '}';
    }
}

