/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.getter.FieldSetter;
import org.simpleflatmapper.reflect.primitive.BooleanFieldSetter;
import org.simpleflatmapper.reflect.primitive.BooleanMethodSetter;
import org.simpleflatmapper.reflect.primitive.BooleanSetter;
import org.simpleflatmapper.reflect.primitive.ByteFieldSetter;
import org.simpleflatmapper.reflect.primitive.ByteMethodSetter;
import org.simpleflatmapper.reflect.primitive.ByteSetter;
import org.simpleflatmapper.reflect.primitive.CharacterFieldSetter;
import org.simpleflatmapper.reflect.primitive.CharacterMethodSetter;
import org.simpleflatmapper.reflect.primitive.CharacterSetter;
import org.simpleflatmapper.reflect.primitive.DoubleFieldSetter;
import org.simpleflatmapper.reflect.primitive.DoubleMethodSetter;
import org.simpleflatmapper.reflect.primitive.DoubleSetter;
import org.simpleflatmapper.reflect.primitive.FloatFieldSetter;
import org.simpleflatmapper.reflect.primitive.FloatMethodSetter;
import org.simpleflatmapper.reflect.primitive.FloatSetter;
import org.simpleflatmapper.reflect.primitive.IntFieldSetter;
import org.simpleflatmapper.reflect.primitive.IntMethodSetter;
import org.simpleflatmapper.reflect.primitive.IntSetter;
import org.simpleflatmapper.reflect.primitive.LongFieldSetter;
import org.simpleflatmapper.reflect.primitive.LongMethodSetter;
import org.simpleflatmapper.reflect.primitive.LongSetter;
import org.simpleflatmapper.reflect.primitive.ShortFieldSetter;
import org.simpleflatmapper.reflect.primitive.ShortMethodSetter;
import org.simpleflatmapper.reflect.primitive.ShortSetter;
import org.simpleflatmapper.reflect.setter.MethodSetter;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.reflect.setter.SetterHelper;

public final class ObjectSetterFactory {
    private final AsmFactory asmFactory;

    public ObjectSetterFactory(AsmFactory asmFactory) {
        this.asmFactory = asmFactory;
    }

    public <T, P> Setter<T, P> getSetter(Class<? extends T> target, String property) {
        Method method = this.lookForMethod(target, property);
        Setter<T, P> setter = method == null ? this.getFieldSetter(target, property) : this.getMethodSetter(method);
        return setter;
    }

    public <T, P> Setter<T, P> getMethodSetter(Method method) {
        boolean accessible;
        boolean bl = accessible = Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers());
        if (this.asmFactory != null && accessible) {
            try {
                return this.asmFactory.createSetter(method);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!accessible) {
            try {
                method.setAccessible(true);
            }
            catch (Exception e) {
                return null;
            }
        }
        return new MethodSetter(method);
    }

    public <T, P> Setter<T, P> getFieldSetter(Class<?> target, String property) {
        Field field = this.lookForField(target, property);
        if (field != null) {
            return this.getFieldSetter(field);
        }
        return null;
    }

    public <T, P> Setter<T, P> getFieldSetter(Field field) {
        boolean accessible;
        boolean bl = accessible = Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers());
        if (this.asmFactory != null && accessible) {
            try {
                return this.asmFactory.createSetter(field);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!accessible) {
            try {
                field.setAccessible(true);
            }
            catch (Exception e) {
                return null;
            }
        }
        return new FieldSetter(field);
    }

    private Method lookForMethod(Class<?> target, String property) {
        if (target == null) {
            return null;
        }
        for (Method m : target.getDeclaredMethods()) {
            if (!SetterHelper.isSetter(m) || !SetterHelper.methodNameMatchesProperty(m.getName(), property)) continue;
            return m;
        }
        if (!Object.class.equals(target)) {
            return this.lookForMethod(target.getSuperclass(), property);
        }
        return null;
    }

    private Field lookForField(Class<?> target, String property) {
        if (target == null) {
            return null;
        }
        for (Field field : target.getDeclaredFields()) {
            if (!SetterHelper.fieldModifiersMatches(field.getModifiers()) || !SetterHelper.fieldNameMatchesProperty(field.getName(), property)) continue;
            return field;
        }
        if (!Object.class.equals(target)) {
            return this.lookForField(target.getSuperclass(), property);
        }
        return null;
    }

    public static <T> BooleanSetter<? super T> toBooleanSetter(Setter<? super T, ? super Boolean> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof BooleanSetter) {
            return (BooleanSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new BooleanMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new BooleanFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    private static boolean isNullSetter(Setter<?, ?> setter) {
        return NullSetter.isNull(setter);
    }

    public static <T> ByteSetter<? super T> toByteSetter(Setter<? super T, ? super Byte> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof ByteSetter) {
            return (ByteSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new ByteMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new ByteFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T> CharacterSetter<? super T> toCharacterSetter(Setter<? super T, ? super Character> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof CharacterSetter) {
            return (CharacterSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new CharacterMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new CharacterFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T> ShortSetter<? super T> toShortSetter(Setter<? super T, ? super Short> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof ShortSetter) {
            return (ShortSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new ShortMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new ShortFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T> IntSetter<? super T> toIntSetter(Setter<? super T, ? super Integer> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof IntSetter) {
            return (IntSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new IntMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new IntFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T> LongSetter<? super T> toLongSetter(Setter<? super T, ? super Long> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof LongSetter) {
            return (LongSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new LongMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new LongFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T> FloatSetter<? super T> toFloatSetter(Setter<? super T, ? super Float> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof FloatSetter) {
            return (FloatSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new FloatMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new FloatFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T> DoubleSetter<? super T> toDoubleSetter(Setter<? super T, ? super Double> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof DoubleSetter) {
            return (DoubleSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new DoubleMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new DoubleFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }
}

