/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.TypeAffinity;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.DefaultPropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.PassThroughPropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.ConstantPredicate;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public class PassThroughClassMeta<T, V>
implements ClassMeta<T> {
    private final ReflectionService reflectionService;
    private final Type type;
    private final InstantiatorDefinition instantiatorDefinition;
    private final PropertyMeta<T, V> propertyMeta;
    private final ClassMeta<V> innerMeta;

    public PassThroughClassMeta(Type type, ReflectionService reflectionService) {
        this.type = type;
        this.reflectionService = reflectionService;
        try {
            String value = TypeHelper.toClass((Type)type).getAnnotation(ReflectionService.PassThrough.class).value();
            ObjectClassMeta objectClassMeta = new ObjectClassMeta(type, reflectionService);
            this.instantiatorDefinition = objectClassMeta.getInstantiatorDefinitions().get(0);
            ConstantPredicate predicate = ConstantPredicate.truePredicate();
            this.propertyMeta = objectClassMeta.newPropertyFinder().findProperty(DefaultPropertyNameMatcher.of(value), new Object[0], (TypeAffinity)null, (Predicate<PropertyMeta<?, ?>>)predicate);
            this.innerMeta = this.propertyMeta.getPropertyClassMeta();
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
    }

    public PassThroughClassMeta(ReflectionService reflectionService, Type type, InstantiatorDefinition instantiatorDefinition, PropertyMeta<T, V> propertyMeta, ClassMeta<V> innerMeta) {
        this.reflectionService = reflectionService;
        this.type = type;
        this.instantiatorDefinition = instantiatorDefinition;
        this.propertyMeta = propertyMeta;
        this.innerMeta = innerMeta;
    }

    @Override
    public ClassMeta<T> withReflectionService(ReflectionService reflectionService) {
        return new PassThroughClassMeta<T, V>(reflectionService, this.type, this.instantiatorDefinition, this.propertyMeta.withReflectionService(reflectionService), reflectionService.getClassMeta(this.innerMeta.getType()));
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return new PassThroughPropertyFinder(this, this.reflectionService.selfScoreFullName());
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public ClassMeta<V> getInnerMeta() {
        return this.innerMeta;
    }

    public PropertyMeta<T, ?> getProperty() {
        return this.propertyMeta;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return Arrays.asList(this.instantiatorDefinition);
    }

    @Override
    public void forEachProperties(Consumer<? super PropertyMeta<T, ?>> consumer) {
        consumer.accept(this.propertyMeta);
    }

    @Override
    public int getNumberOfProperties() {
        return 1;
    }

    @Override
    public boolean needTransformer() {
        return false;
    }
}

