/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.simpleflatmapper.reflect.ConstructorNotFoundException;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.ScoredGetter;
import org.simpleflatmapper.reflect.ScoredSetter;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.TuplePropertyFinder;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TupleHelper;
import org.simpleflatmapper.util.TypeHelper;

public class TupleClassMeta<T>
implements ClassMeta<T> {
    private final ReflectionService reflectionService;
    private final Type type;
    private final InstantiatorDefinition instantiatorDefinition;
    private final List<ConstructorPropertyMeta<T, ?>> propertyMetas;

    public TupleClassMeta(Type type, ReflectionService reflectionService) {
        this.type = type;
        this.reflectionService = reflectionService;
        try {
            this.instantiatorDefinition = this.getInstantiatorDefinition(type, reflectionService);
            this.propertyMetas = TupleClassMeta.getPropertyMetas(this.instantiatorDefinition, reflectionService, type);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
    }

    private static <T> List<ConstructorPropertyMeta<T, ?>> getPropertyMetas(InstantiatorDefinition instantiatorDefinition, ReflectionService reflectionService, Type type) {
        int size = instantiatorDefinition.getParameters().length;
        ArrayList propertyMetas = new ArrayList();
        for (int i = 0; i < size; ++i) {
            propertyMetas.add(TupleClassMeta.newConstructorPropertyMeta(instantiatorDefinition, i, reflectionService, type));
        }
        return propertyMetas;
    }

    private static <T, E> ConstructorPropertyMeta<T, E> newConstructorPropertyMeta(InstantiatorDefinition instantiatorDefinition, int i, ReflectionService reflectionService, Type type) {
        Class tClass = TypeHelper.toClass((Type)type);
        Parameter parameter = instantiatorDefinition.getParameters()[i];
        Getter getter = reflectionService.getObjectGetterFactory().getGetter(tClass, parameter.getName());
        return new ConstructorPropertyMeta("element" + i, type, reflectionService, parameter, ScoredGetter.of(getter, Integer.MAX_VALUE), ScoredSetter.nullSetter(), instantiatorDefinition, null);
    }

    private InstantiatorDefinition getInstantiatorDefinition(Type type, ReflectionService reflectionService) throws IOException {
        List<InstantiatorDefinition> definitions = reflectionService.extractInstantiator(type);
        ListIterator<InstantiatorDefinition> iterator = definitions.listIterator();
        while (iterator.hasNext()) {
            InstantiatorDefinition definition = iterator.next();
            if (!this.isTupleConstructor(type, definition)) continue;
            return this.respecifyParameterNames((ExecutableInstantiatorDefinition)definition);
        }
        throw new ConstructorNotFoundException("Cannot find eligible tuple constructor definition for " + type);
    }

    private InstantiatorDefinition respecifyParameterNames(ExecutableInstantiatorDefinition definition) {
        Parameter[] parameters = definition.getParameters();
        if (parameters.length > 0 && parameters[0].getName() == null) {
            Parameter[] newParams = new Parameter[parameters.length];
            ElementNameGenerator nameGenerator = TupleClassMeta.elementNameGenerator(definition.getExecutable().getDeclaringClass());
            for (int i = 0; i < parameters.length; ++i) {
                newParams[i] = new Parameter(i, nameGenerator.name(i), parameters[i].getType(), parameters[i].getGenericType());
            }
            return new ExecutableInstantiatorDefinition((Constructor)definition.getExecutable(), newParams);
        }
        return definition;
    }

    private boolean isTupleConstructor(Type type, InstantiatorDefinition definition) {
        if (type instanceof ParameterizedType && definition.getType() != InstantiatorDefinition.Type.BUILDER) {
            ParameterizedType pt = (ParameterizedType)type;
            return pt.getActualTypeArguments().length == definition.getParameters().length;
        }
        return true;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder(Predicate<PropertyMeta<?, ?>> propertyFilter) {
        return new TuplePropertyFinder(this, propertyFilter, this.reflectionService.selfScoreFullName());
    }

    @Override
    public Type getType() {
        return this.type;
    }

    private static ElementNameGenerator elementNameGenerator(Type type) {
        Class clazz = TypeHelper.toClass((Type)type);
        if (TupleHelper.isJoolTuple((Type)clazz)) {
            return new JoolTupleNameGenerator();
        }
        return new SFMTupleNameGenerator();
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return Arrays.asList(this.instantiatorDefinition);
    }

    @Override
    public void forEachProperties(Consumer<? super PropertyMeta<T, ?>> consumer) {
        for (PropertyMeta propertyMeta : this.propertyMetas) {
            consumer.accept((Object)propertyMeta);
        }
    }

    @Override
    public int getNumberOfProperties() {
        return this.propertyMetas.size();
    }

    @Override
    public boolean needTransformer() {
        return false;
    }

    public int getTupleSize() {
        return this.instantiatorDefinition.getParameters().length;
    }

    static class JoolTupleNameGenerator
    implements ElementNameGenerator {
        JoolTupleNameGenerator() {
        }

        @Override
        public String name(int i) {
            return "v" + (i + 1);
        }
    }

    static class SFMTupleNameGenerator
    implements ElementNameGenerator {
        SFMTupleNameGenerator() {
        }

        @Override
        public String name(int i) {
            return "element" + i;
        }
    }

    static interface ElementNameGenerator {
        public String name(int var1);
    }
}

