/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.MethodBiFunctionPair;
import org.simpleflatmapper.reflect.MethodGetterPair;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.getter.IdentityGetter;
import org.simpleflatmapper.reflect.impl.BuilderBiInstantiator;
import org.simpleflatmapper.reflect.impl.BuilderInstantiator;
import org.simpleflatmapper.reflect.impl.EmptyConstructorBiInstantiator;
import org.simpleflatmapper.reflect.impl.EmptyConstructorInstantiator;
import org.simpleflatmapper.reflect.impl.EmptyStaticMethodBiInstantiator;
import org.simpleflatmapper.reflect.impl.EmptyStaticMethodInstantiator;
import org.simpleflatmapper.reflect.impl.InjectConstructorBiInstantiator;
import org.simpleflatmapper.reflect.impl.InjectConstructorInstantiator;
import org.simpleflatmapper.reflect.impl.InjectStaticMethodBiInstantiator;
import org.simpleflatmapper.reflect.impl.InjectStaticMethodInstantiator;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.instantiator.InstantiatorDefinitions;
import org.simpleflatmapper.util.BiFunction;
import org.simpleflatmapper.util.ErrorHelper;

public class InstantiatorFactory {
    private final AsmFactory asmFactory;
    private final boolean failOnAsmError;

    public InstantiatorFactory(AsmFactory asmFactory) {
        this(asmFactory, false);
    }

    public InstantiatorFactory(AsmFactory asmFactory, boolean faileOnAsmError) {
        this.asmFactory = asmFactory;
        this.failOnAsmError = faileOnAsmError;
    }

    public <S1, S2, T> BiInstantiator<S1, S2, T> getBiInstantiator(Type target, Class<?> s1, Class<?> s2, List<InstantiatorDefinition> constructors, Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injections, boolean useAsmIfEnabled) throws SecurityException {
        InstantiatorDefinition instantiatorDefinition = InstantiatorFactory.getSmallerConstructor(constructors);
        if (instantiatorDefinition == null) {
            throw new IllegalArgumentException("No constructor available for " + target);
        }
        return this.getBiInstantiator(instantiatorDefinition, s1, s2, injections, useAsmIfEnabled);
    }

    public <S1, S2, T> BiInstantiator<S1, S2, T> getBiInstantiator(InstantiatorDefinition instantiatorDefinition, Class<?> s1, Class<?> s2, Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injections, boolean useAsmIfEnabled) {
        block14: {
            this.checkParameters(instantiatorDefinition, injections.keySet());
            if (this.asmFactory != null && useAsmIfEnabled) {
                if (instantiatorDefinition instanceof ExecutableInstantiatorDefinition) {
                    ExecutableInstantiatorDefinition executableInstantiatorDefinition = (ExecutableInstantiatorDefinition)instantiatorDefinition;
                    Member executable = executableInstantiatorDefinition.getExecutable();
                    if (Modifier.isPublic(executable.getModifiers())) {
                        try {
                            return this.asmFactory.createBiInstantiator(s1, s2, executableInstantiatorDefinition, injections);
                        }
                        catch (Exception e) {
                            if (this.failOnAsmError) {
                                ErrorHelper.rethrow((Throwable)e);
                            }
                        }
                    }
                } else {
                    try {
                        return this.asmFactory.createBiInstantiator(s1, s2, (BuilderInstantiatorDefinition)instantiatorDefinition, injections);
                    }
                    catch (Exception e) {
                        if (!this.failOnAsmError) break block14;
                        ErrorHelper.rethrow((Throwable)e);
                    }
                }
            }
        }
        switch (instantiatorDefinition.getType()) {
            case CONSTRUCTOR: {
                return this.constructorBiInstantiator((ExecutableInstantiatorDefinition)instantiatorDefinition, injections);
            }
            case METHOD: {
                return this.methodBiInstantiator((ExecutableInstantiatorDefinition)instantiatorDefinition, injections);
            }
            case BUILDER: {
                return this.builderBiInstantiator((BuilderInstantiatorDefinition)instantiatorDefinition, injections, useAsmIfEnabled);
            }
        }
        throw new IllegalArgumentException("Unsupported executable type " + instantiatorDefinition);
    }

    public <S, T> Instantiator<S, T> getInstantiator(Type target, Class<S> source, List<InstantiatorDefinition> constructors, Map<Parameter, Getter<? super S, ?>> injections, boolean useAsmIfEnabled) throws SecurityException {
        InstantiatorDefinition instantiatorDefinition = InstantiatorFactory.getSmallerConstructor(constructors);
        if (instantiatorDefinition == null) {
            throw new IllegalArgumentException("No constructor available for " + target);
        }
        return this.getInstantiator(instantiatorDefinition, source, injections, useAsmIfEnabled);
    }

    public <S, T> Instantiator<S, T> getInstantiator(InstantiatorDefinition instantiatorDefinition, Class<S> source, Map<Parameter, Getter<? super S, ?>> injections, boolean useAsmIfEnabled) {
        block14: {
            this.checkParameters(instantiatorDefinition, injections.keySet());
            if (this.asmFactory != null && useAsmIfEnabled) {
                if (instantiatorDefinition instanceof ExecutableInstantiatorDefinition) {
                    ExecutableInstantiatorDefinition executableInstantiatorDefinition = (ExecutableInstantiatorDefinition)instantiatorDefinition;
                    Member executable = executableInstantiatorDefinition.getExecutable();
                    if (Modifier.isPublic(executable.getModifiers())) {
                        try {
                            return this.asmFactory.createInstantiator(source, executableInstantiatorDefinition, injections);
                        }
                        catch (Exception e) {
                            if (this.failOnAsmError) {
                                ErrorHelper.rethrow((Throwable)e);
                            }
                        }
                    }
                } else {
                    try {
                        return this.asmFactory.createInstantiator(source, (BuilderInstantiatorDefinition)instantiatorDefinition, injections);
                    }
                    catch (Exception e) {
                        if (!this.failOnAsmError) break block14;
                        ErrorHelper.rethrow((Throwable)e);
                    }
                }
            }
        }
        switch (instantiatorDefinition.getType()) {
            case CONSTRUCTOR: {
                return this.constructorInstantiator((ExecutableInstantiatorDefinition)instantiatorDefinition, injections);
            }
            case METHOD: {
                return this.methodInstantiator((ExecutableInstantiatorDefinition)instantiatorDefinition, injections);
            }
            case BUILDER: {
                return this.builderInstantiator((BuilderInstantiatorDefinition)instantiatorDefinition, injections, useAsmIfEnabled);
            }
        }
        throw new IllegalArgumentException("Unsupported executable type " + instantiatorDefinition);
    }

    private void checkParameters(InstantiatorDefinition instantiatorDefinition, Set<Parameter> parameters) {
        for (Parameter p : parameters) {
            if (instantiatorDefinition.hasParam(p)) continue;
            throw new IllegalArgumentException("Could not find " + p + " in " + instantiatorDefinition + " raise issue");
        }
    }

    private <S, T> Instantiator<S, T> builderInstantiator(BuilderInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections, boolean useAsmIfEnabled) {
        Instantiator<? super S, T> buildInstantiator = this.getInstantiator(instantiatorDefinition.getBuilderInstantiator(), Void.class, new HashMap(), useAsmIfEnabled);
        ArrayList<MethodGetterPair<? super S>> chainedArguments = new ArrayList<MethodGetterPair<? super S>>();
        ArrayList<MethodGetterPair<? super S>> unchainedArguments = new ArrayList<MethodGetterPair<? super S>>();
        boolean i = false;
        for (Map.Entry<Parameter, Getter<S, ?>> e : injections.entrySet()) {
            MethodGetterPair<S> arguments = new MethodGetterPair<S>(instantiatorDefinition.getSetters().get(e.getKey()), e.getValue());
            if (Void.TYPE.equals(arguments.getMethod().getReturnType())) {
                unchainedArguments.add(arguments);
                continue;
            }
            chainedArguments.add(arguments);
        }
        return new BuilderInstantiator(buildInstantiator, chainedArguments.toArray(new MethodGetterPair[0]), unchainedArguments.toArray(new MethodGetterPair[0]), instantiatorDefinition.getBuildMethod());
    }

    private <S, T> Instantiator<S, T> methodInstantiator(ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections) {
        Method m = (Method)instantiatorDefinition.getExecutable();
        if (m.getParameterTypes().length == 0) {
            return new EmptyStaticMethodInstantiator(m);
        }
        return new InjectStaticMethodInstantiator(instantiatorDefinition, injections);
    }

    private <S, T> Instantiator<S, T> constructorInstantiator(ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections) {
        Constructor c = (Constructor)instantiatorDefinition.getExecutable();
        if (c.getParameterTypes().length == 0) {
            return new EmptyConstructorInstantiator(c);
        }
        return new InjectConstructorInstantiator(instantiatorDefinition, injections);
    }

    private <S1, S2, T> BiInstantiator<S1, S2, T> builderBiInstantiator(BuilderInstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injections, boolean useAsmIfEnabled) {
        Instantiator buildInstantiator = this.getInstantiator(instantiatorDefinition.getBuilderInstantiator(), Void.class, new HashMap(), useAsmIfEnabled);
        ArrayList<MethodBiFunctionPair<? super S1, ? super S2>> chainedArguments = new ArrayList<MethodBiFunctionPair<? super S1, ? super S2>>();
        ArrayList<MethodBiFunctionPair<? super S1, ? super S2>> unchainedArguments = new ArrayList<MethodBiFunctionPair<? super S1, ? super S2>>();
        boolean i = false;
        for (Map.Entry<Parameter, BiFunction<S1, S2, ?>> e : injections.entrySet()) {
            MethodBiFunctionPair<S1, S2> arguments = new MethodBiFunctionPair<S1, S2>(instantiatorDefinition.getSetters().get(e.getKey()), e.getValue());
            if (Void.TYPE.equals(arguments.getMethod().getReturnType())) {
                unchainedArguments.add(arguments);
                continue;
            }
            chainedArguments.add(arguments);
        }
        return new BuilderBiInstantiator(buildInstantiator, chainedArguments.toArray(new MethodBiFunctionPair[0]), unchainedArguments.toArray(new MethodBiFunctionPair[0]), instantiatorDefinition.getBuildMethod());
    }

    private <S1, S2, T> BiInstantiator<S1, S2, T> methodBiInstantiator(ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injections) {
        Method m = (Method)instantiatorDefinition.getExecutable();
        if (m.getParameterTypes().length == 0) {
            return new EmptyStaticMethodBiInstantiator(m);
        }
        return new InjectStaticMethodBiInstantiator(instantiatorDefinition, injections);
    }

    private <S1, S2, T> BiInstantiator<S1, S2, T> constructorBiInstantiator(ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injections) {
        Constructor c = (Constructor)instantiatorDefinition.getExecutable();
        if (c.getParameterTypes().length == 0) {
            return new EmptyConstructorBiInstantiator(c);
        }
        return new InjectConstructorBiInstantiator(instantiatorDefinition, injections);
    }

    public static InstantiatorDefinition getSmallerConstructor(List<InstantiatorDefinition> constructors) {
        if (constructors == null) {
            return null;
        }
        InstantiatorDefinition selectedConstructor = null;
        for (InstantiatorDefinition c : constructors) {
            if (selectedConstructor != null && InstantiatorDefinitions.COMPARATOR.compare(c, selectedConstructor) >= 0) continue;
            selectedConstructor = c;
        }
        return selectedConstructor;
    }

    public <S, T> Instantiator<S, T> getArrayInstantiator(Class<?> elementType, int length) {
        return new ArrayInstantiator(elementType, length);
    }

    public <S1, S2, T> BiInstantiator<S1, S2, T> getArrayBiInstantiator(Class<?> elementType, int length) {
        return new ArrayBiInstantiator(elementType, length);
    }

    public <S, T> Instantiator<S, T> getOneArgIdentityInstantiator(InstantiatorDefinition id) {
        if (id.getParameters().length != 1) {
            throw new IllegalArgumentException("Definition does not have one param " + Arrays.asList(id.getParameters()));
        }
        HashMap injections = new HashMap();
        injections.put(id.getParameters()[0], new IdentityGetter());
        return this.getInstantiator(id, id.getParameters()[0].getType(), injections, true);
    }

    private static final class ArrayBiInstantiator<S1, S2, T>
    implements BiInstantiator<S1, S2, T> {
        private final Class<?> elementType;
        private final int length;

        public ArrayBiInstantiator(Class<?> elementType, int length) {
            this.elementType = elementType;
            this.length = length;
        }

        @Override
        public T newInstance(S1 s1, S2 s2) throws Exception {
            return (T)Array.newInstance(this.elementType, this.length);
        }
    }

    private static final class ArrayInstantiator<S, T>
    implements Instantiator<S, T> {
        private final Class<?> elementType;
        private final int length;

        public ArrayInstantiator(Class<?> elementType, int length) {
            this.elementType = elementType;
            this.length = length;
        }

        @Override
        public T newInstance(S s) throws Exception {
            return (T)Array.newInstance(this.elementType, this.length);
        }
    }
}

