/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.PropertyNameMatch;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcherKeyValuePair;
import org.simpleflatmapper.util.Asserts;

public final class DefaultPropertyNameMatcher
implements PropertyNameMatcher {
    private final String column;
    private final int from;
    private final boolean exactMatch;
    private final boolean caseSensitive;

    public DefaultPropertyNameMatcher(String column, int from, boolean exactMatch, boolean caseSensitive) {
        this.column = (String)Asserts.requireNonNull((String)"property", (Object)column);
        this.from = from;
        this.exactMatch = exactMatch;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean matches(CharSequence property) {
        return property != null && this._partialMatch(property) == this.column.length();
    }

    @Override
    public IndexedColumn matchIndex() {
        int listIndexEnd;
        int listIndexStart;
        int index = -1;
        for (listIndexStart = this.from; listIndexStart < this.column.length() && !Character.isDigit(this.column.charAt(listIndexStart)); ++listIndexStart) {
        }
        for (listIndexEnd = listIndexStart; listIndexEnd < this.column.length() && Character.isDigit(this.column.charAt(listIndexEnd)); ++listIndexEnd) {
        }
        if (listIndexStart != listIndexEnd) {
            index = Integer.parseInt(this.column.substring(listIndexStart, listIndexEnd));
        }
        if (index == -1) {
            return null;
        }
        DefaultPropertyNameMatcher subPropertyNameMatcher = null;
        if (listIndexEnd < this.column.length()) {
            subPropertyNameMatcher = new DefaultPropertyNameMatcher(this.column, listIndexEnd, this.exactMatch, this.caseSensitive);
        }
        return new IndexedColumn(index, subPropertyNameMatcher);
    }

    private int _partialMatch(CharSequence property) {
        if (property == null) {
            return -1;
        }
        int indexColumn = this.from;
        int indexProperty = 0;
        boolean nextToUpperCase = false;
        while (indexProperty < property.length()) {
            char charProperty = property.charAt(indexProperty);
            if (indexColumn < this.column.length()) {
                char charColumn = this.column.charAt(indexColumn);
                if (nextToUpperCase) {
                    charColumn = Character.toUpperCase(charColumn);
                    nextToUpperCase = false;
                }
                ++indexColumn;
                if (this.ignoreCharacter(charColumn)) {
                    if (this.ignoreCharacter(charProperty)) {
                        ++indexProperty;
                    }
                    if (!this.caseSensitive) continue;
                    nextToUpperCase = true;
                    continue;
                }
                if (this.areDifferentCharacters(charProperty, charColumn)) {
                    return -1;
                }
                ++indexProperty;
                continue;
            }
            return -1;
        }
        return indexColumn;
    }

    private boolean areDifferentCharacters(char c1, char c2) {
        if (this.caseSensitive) {
            return c1 != c2;
        }
        return Character.toLowerCase(c1) != Character.toLowerCase(c2);
    }

    private boolean ignoreCharacter(char charColumn) {
        return !this.exactMatch && this.isSeparatorChar(charColumn);
    }

    private boolean isSeparatorChar(char charColumn) {
        return charColumn == '_' || charColumn == ' ' || charColumn == '.';
    }

    @Override
    public PropertyNameMatcher partialMatch(CharSequence property) {
        int index = this._partialMatch(property);
        if (index != -1) {
            return new DefaultPropertyNameMatcher(this.column, index, this.exactMatch, this.caseSensitive);
        }
        return null;
    }

    @Override
    public PropertyNameMatch speculativeMatch() {
        int index = this._speculativeMatch();
        if (index != -1) {
            return new PropertyNameMatch(this.column.substring(this.from, index), new DefaultPropertyNameMatcher(this.column, index, this.exactMatch, this.caseSensitive));
        }
        return null;
    }

    @Override
    public List<PropertyNameMatcherKeyValuePair> keyValuePairs() {
        ArrayList<PropertyNameMatcherKeyValuePair> keyValuePairs = new ArrayList<PropertyNameMatcherKeyValuePair>();
        keyValuePairs.add(new PropertyNameMatcherKeyValuePair(new DefaultPropertyNameMatcher(this.column, this.from, this.exactMatch, this.caseSensitive), new DefaultPropertyNameMatcher("", 0, this.exactMatch, this.caseSensitive)));
        for (int i = this.column.length() - 1; i >= this.from; --i) {
            char c = this.column.charAt(i);
            if (!this.isSeparatorChar(c)) continue;
            DefaultPropertyNameMatcher key = new DefaultPropertyNameMatcher(this.column.substring(this.from, i), 0, this.exactMatch, this.caseSensitive);
            DefaultPropertyNameMatcher value = new DefaultPropertyNameMatcher(this.column, this.from + i + 1, this.exactMatch, this.caseSensitive);
            keyValuePairs.add(new PropertyNameMatcherKeyValuePair(key, value));
        }
        return keyValuePairs;
    }

    private int _speculativeMatch() {
        for (int i = this.from; i < this.column.length(); ++i) {
            char c = this.column.charAt(i);
            if (c != '_' && c != '.') continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.column.substring(this.from, this.column.length());
    }

    public static PropertyNameMatcher of(String value) {
        return new DefaultPropertyNameMatcher(value, 0, false, false);
    }

    public static PropertyNameMatcher exact(String value) {
        return new DefaultPropertyNameMatcher(value, 0, true, true);
    }
}

