/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ArrayPropertyFinder;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.util.BooleanSupplier;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.IntFactory;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public class ArrayClassMeta<T, E>
implements ClassMeta<T> {
    private final ReflectionService reflectionService;
    private final Type elementTarget;
    private final ClassMeta<E> elementClassMeta;
    private final Type type;
    private final InstantiatorDefinition constructor;

    public ArrayClassMeta(Type type, Type elementTarget, ReflectionService reflectionService) {
        this.type = type;
        this.elementTarget = elementTarget;
        this.reflectionService = reflectionService;
        this.elementClassMeta = reflectionService.getClassMeta(elementTarget);
        this.constructor = this.getConstructor(type);
    }

    private InstantiatorDefinition getConstructor(Type type) {
        if (TypeHelper.isArray((Type)type)) {
            return null;
        }
        Class<?> implClass = this.findListImpl(type);
        try {
            return new ExecutableInstantiatorDefinition(implClass.getDeclaredConstructor(new Class[0]), new Parameter[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No empty constructor for " + implClass);
        }
    }

    private Class<?> findListImpl(Type type) {
        Class clazz = TypeHelper.toClass((Type)type);
        if (clazz.isInterface()) {
            if (List.class.equals((Object)clazz)) {
                return ArrayList.class;
            }
            if (Set.class.equals((Object)clazz)) {
                return HashSet.class;
            }
        } else if (!Modifier.isAbstract(clazz.getModifiers())) {
            return clazz;
        }
        throw new IllegalArgumentException("No known List impl for " + type);
    }

    public ClassMeta<E> getElementClassMeta() {
        return this.elementClassMeta;
    }

    public Type getElementTarget() {
        return this.elementTarget;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder(Predicate<PropertyMeta<?, ?>> propertyFilter) {
        return new ArrayPropertyFinder(this, propertyFilter);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public boolean isArray() {
        return TypeHelper.isArray((Type)this.type);
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        if (this.constructor != null) {
            return Arrays.asList(this.constructor);
        }
        return Collections.emptyList();
    }

    @Override
    public void forEachProperties(Consumer<? super PropertyMeta<T, ?>> consumer) {
        throw new UnsupportedOperationException("Cannot forEach property on array as variable");
    }

    public <T, E> IntFactory<Setter<T, E>> newSetterFactory(final BooleanSupplier isVertical) {
        if (TypeHelper.isArray((Type)this.type)) {
            return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    return new IndexArraySetter(i);
                }
            };
        }
        if (TypeHelper.isAssignable((Type)this.type, List.class)) {
            return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    if (isVertical.getAsBoolean() && i == 0) {
                        return new AppendListSetter();
                    }
                    return new IndexListSetter(i);
                }
            };
        }
        if (TypeHelper.isAssignable((Type)this.type, Set.class)) {
            return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    return new AppendSetSetter();
                }
            };
        }
        return new IntFactory<Setter<T, E>>(){

            public Setter<T, E> newInstance(int i) {
                return NullSetter.NULL_SETTER;
            }
        };
    }

    public <T, E> IntFactory<Getter<T, E>> newGetterFactory() {
        if (TypeHelper.isArray((Type)this.type)) {
            return new IntFactory<Getter<T, E>>(){

                public Getter<T, E> newInstance(int i) {
                    return new IndexArrayGetter(i);
                }
            };
        }
        if (TypeHelper.isAssignable((Type)this.type, List.class)) {
            return new IntFactory<Getter<T, E>>(){

                public Getter<T, E> newInstance(int i) {
                    return new IndexListGetter(i);
                }
            };
        }
        return new IntFactory<Getter<T, E>>(){

            public Getter<T, E> newInstance(int i) {
                return NullGetter.getter();
            }
        };
    }

    private static class AppendSetSetter<E>
    implements Setter<Set<E>, E> {
        private AppendSetSetter() {
        }

        @Override
        public void set(Set<E> target, E value) throws Exception {
            target.add(value);
        }

        public String toString() {
            return "AppendSetSetter{}";
        }
    }

    private static class AppendListSetter<E>
    implements Setter<List<E>, E> {
        private AppendListSetter() {
        }

        @Override
        public void set(List<E> target, E value) throws Exception {
            target.add(value);
        }

        public String toString() {
            return "AppendListSetter{}";
        }
    }

    private static class IndexListSetter<E>
    implements Setter<List<E>, E> {
        private final int index;

        private IndexListSetter(int index) {
            this.index = index;
        }

        @Override
        public void set(List<E> target, E value) throws Exception {
            while (target.size() <= this.index) {
                target.add(null);
            }
            target.set(this.index, value);
        }
    }

    private static class IndexListGetter<E>
    implements Getter<List<E>, E> {
        private final int index;

        private IndexListGetter(int index) {
            this.index = index;
        }

        @Override
        public E get(List<E> target) throws Exception {
            if (this.index < target.size()) {
                return target.get(this.index);
            }
            return null;
        }
    }

    public static final class IndexArrayGetter<E>
    implements Getter<E[], E> {
        private final int index;

        private IndexArrayGetter(int index) {
            this.index = index;
        }

        @Override
        public E get(E[] target) throws Exception {
            return target[this.index];
        }
    }

    public static final class IndexArraySetter<E>
    implements Setter<E[], E> {
        private final int index;

        private IndexArraySetter(int index) {
            this.index = index;
        }

        @Override
        public void set(E[] target, E value) throws Exception {
            target[this.index] = value;
        }
    }
}

