/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.impl;

import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.util.BiFactory;
import org.simpleflatmapper.util.TypeHelper;

public final class BiArgumentBuilder<S1, S2> {
    private static final BiFactory NULL_FACTORIES = new BiFactory(){

        public Object newInstance(Object o, Object o2) {
            return null;
        }
    };
    private static final Map<Class<?>, BiFactory> DEFAULT_FACTORIES = new HashMap();
    private final BiFactory<? super S1, ? super S2, ?>[] factories;

    public BiArgumentBuilder(InstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections) {
        Parameter[] parameters = instantiatorDefinition.getParameters();
        this.factories = new BiFactory[parameters.length];
        for (int i = 0; i < this.factories.length; ++i) {
            Parameter param = parameters[i];
            BiFactory factory = injections.get(param);
            if (factory == null) {
                factory = TypeHelper.isPrimitive(param.getType()) ? DEFAULT_FACTORIES.get(param.getType()) : NULL_FACTORIES;
            }
            this.factories[i] = factory;
        }
    }

    public Object[] build(S1 s1, S2 s2) throws Exception {
        Object[] args = new Object[this.factories.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.factories[i].newInstance(s1, s2);
        }
        return args;
    }

    static {
        DEFAULT_FACTORIES.put(Boolean.TYPE, new BiFactory(){

            public Object newInstance(Object o, Object o2) {
                return Boolean.TRUE;
            }
        });
        DEFAULT_FACTORIES.put(Byte.TYPE, new BiFactory(){

            public Object newInstance(Object o, Object o2) {
                return (byte)0;
            }
        });
        DEFAULT_FACTORIES.put(Character.TYPE, new BiFactory(){

            public Object newInstance(Object o, Object o2) {
                return Character.valueOf('\u0000');
            }
        });
        DEFAULT_FACTORIES.put(Short.TYPE, new BiFactory(){

            public Object newInstance(Object o, Object o2) {
                return (short)0;
            }
        });
        DEFAULT_FACTORIES.put(Integer.TYPE, new BiFactory(){

            public Object newInstance(Object o, Object o2) {
                return 0;
            }
        });
        DEFAULT_FACTORIES.put(Long.TYPE, new BiFactory(){

            public Object newInstance(Object o, Object o2) {
                return 0L;
            }
        });
        DEFAULT_FACTORIES.put(Float.TYPE, new BiFactory(){

            public Object newInstance(Object o, Object o2) {
                return Float.valueOf(0.0f);
            }
        });
        DEFAULT_FACTORIES.put(Double.TYPE, new BiFactory(){

            public Object newInstance(Object o, Object o2) {
                return 0.0;
            }
        });
    }
}

