/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.reflect.meta.AbstractIndexPropertyFinder;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.ArrayElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.ListElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.util.BooleanSupplier;
import org.simpleflatmapper.util.Predicate;

public class ArrayPropertyFinder<T, E>
extends AbstractIndexPropertyFinder<T> {
    private final List<IndexedElement<T, E>> elements = new ArrayList<IndexedElement<T, E>>();

    public ArrayPropertyFinder(ArrayClassMeta<T, E> arrayClassMeta, Predicate<PropertyMeta<?, ?>> propertyFilter) {
        super(arrayClassMeta, propertyFilter);
    }

    @Override
    protected IndexedElement<T, E> getIndexedElement(IndexedColumn indexedColumn) {
        while (this.elements.size() <= indexedColumn.getIndexValue()) {
            this.elements.add(new IndexedElement<T, E>(this.newElementPropertyMeta(this.elements.size(), "element" + this.elements.size()), ((ArrayClassMeta)this.classMeta).getElementClassMeta(), this.propertyFilter));
        }
        return this.elements.get(indexedColumn.getIndexValue());
    }

    private PropertyMeta<T, E> newElementPropertyMeta(int index, String name) {
        ArrayClassMeta arrayClassMeta = (ArrayClassMeta)this.classMeta;
        if (arrayClassMeta.isArray()) {
            return new ArrayElementPropertyMeta(name, this.classMeta.getType(), arrayClassMeta.getReflectionService(), index, arrayClassMeta);
        }
        return new ListElementPropertyMeta(name, this.classMeta.getType(), arrayClassMeta.getReflectionService(), index, arrayClassMeta, new BooleanSupplier(){

            public boolean getAsBoolean() {
                return ArrayPropertyFinder.this.elements.size() == 1;
            }
        });
    }

    @Override
    protected void extrapolateIndex(PropertyNameMatcher propertyNameMatcher, PropertyFinder.FoundProperty foundProperty, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer) {
        ClassMeta elementClassMeta = ((ArrayClassMeta)this.classMeta).getElementClassMeta();
        PropertyMeta property = elementClassMeta.newPropertyFinder(this.propertyFilter).findProperty(propertyNameMatcher);
        if (property != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                IndexedElement<T, E> element = this.elements.get(i);
                if (element.hasProperty(property)) continue;
                this.lookForAgainstColumn(new IndexedColumn(i, propertyNameMatcher), foundProperty, score, propertyFinderTransformer);
                return;
            }
            this.lookForAgainstColumn(new IndexedColumn(this.elements.size(), propertyNameMatcher), foundProperty, score, propertyFinderTransformer);
        }
    }

    @Override
    protected boolean isValidIndex(IndexedColumn indexedColumn) {
        return indexedColumn.getIndexValue() >= 0;
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(String name) {
        return null;
    }
}

