/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatch;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.Predicate;

public abstract class AbstractIndexPropertyFinder<T>
extends PropertyFinder<T> {
    protected final ClassMeta<T> classMeta;
    protected final List<IndexedElement<T, ?>> elements = new ArrayList();

    public AbstractIndexPropertyFinder(ClassMeta<T> classMeta, Predicate<PropertyMeta<?, ?>> propertyFilter, boolean selfScoreFullName) {
        super(propertyFilter, selfScoreFullName);
        this.classMeta = classMeta;
    }

    @Override
    public void lookForProperties(PropertyNameMatcher propertyNameMatcher, Object[] properties, PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
        IndexedColumn indexedColumn = propertyNameMatcher.matchIndex();
        if (indexedColumn != null) {
            this.lookForAgainstColumn(indexedColumn, properties, matchingProperties, score.arrayIndex(indexedColumn.getIndexValue()), propertyFinderTransformer, typeAffinityScorer);
        } else {
            this.extrapolateIndex(propertyNameMatcher, properties, matchingProperties, score.speculative(), propertyFinderTransformer, typeAffinityScorer);
            this.speculativeMatching(propertyNameMatcher, properties, matchingProperties, score.speculative(), propertyFinderTransformer, typeAffinityScorer);
        }
    }

    protected void lookForAgainstColumn(IndexedColumn indexedColumn, Object[] properties, final PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
        if (indexedColumn == null || !this.isValidIndex(indexedColumn)) {
            return;
        }
        final IndexedElement<T, ?> indexedElement = this.getIndexedElement(indexedColumn);
        if (indexedColumn.getSubPropertyNameMatcher() == null) {
            matchingProperties.found(indexedElement.getPropertyMeta(), new Runnable(){

                @Override
                public void run() {
                    if (!indexedElement.hasProperty("{this}")) {
                        indexedElement.addProperty("{this}");
                    }
                }
            }, score.self(indexedElement.getElementClassMeta(), indexedColumn.getIndexProperty()), typeAffinityScorer);
            return;
        }
        PropertyFinder<?> eltPropertyFinder = indexedElement.getPropertyFinder();
        if (eltPropertyFinder == null) {
            return;
        }
        propertyFinderTransformer.apply(eltPropertyFinder).lookForProperties(indexedColumn.getSubPropertyNameMatcher(), properties, new PropertyFinder.FoundProperty(){

            public void found(final PropertyMeta propertyMeta, final Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
                PropertyMeta<Object, Object> subProperty = propertyMeta.isSelf() ? indexedElement.getPropertyMeta() : new SubPropertyMeta(AbstractIndexPropertyFinder.this.classMeta.getReflectionService(), indexedElement.getPropertyMeta(), propertyMeta);
                matchingProperties.found(subProperty, new Runnable(){

                    @Override
                    public void run() {
                        selectionCallback.run();
                        indexedElement.addProperty(propertyMeta);
                    }
                }, score, typeAffinityScorer);
            }
        }, score.matches(indexedColumn.getIndexProperty()), true, propertyFinderTransformer, typeAffinityScorer);
    }

    private void speculativeMatching(PropertyNameMatcher propertyNameMatcher, Object[] properties, PropertyFinder.FoundProperty foundProperty, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
        PropertyNameMatch speculativeMatch = propertyNameMatcher.speculativeMatch();
        if (speculativeMatch != null) {
            this.extrapolateIndex(speculativeMatch.getLeftOverMatcher(), properties, foundProperty, score.speculative(), propertyFinderTransformer, typeAffinityScorer);
        }
    }

    protected abstract boolean isValidIndex(IndexedColumn var1);

    protected abstract <E> IndexedElement<T, ?> getIndexedElement(IndexedColumn var1);

    protected abstract void extrapolateIndex(PropertyNameMatcher var1, Object[] var2, PropertyFinder.FoundProperty var3, PropertyMatchingScore var4, PropertyFinder.PropertyFinderTransformer var5, PropertyFinder.TypeAffinityScorer var6);

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.classMeta.getInstantiatorDefinitions();
    }

    @Override
    public Type getOwnerType() {
        return this.classMeta.getType();
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> owner) {
        PropertyFinder<?> ie = this.lookForPropertyFinder(owner);
        if (ie != null) {
            return ie;
        }
        throw new IllegalArgumentException("Unexpected owner " + owner);
    }

    private PropertyFinder<?> lookForPropertyFinder(PropertyMeta<?, ?> owner) {
        for (IndexedElement<T, ?> ie : this.elements) {
            if (!this.indexMatches(ie.getPropertyMeta(), owner)) continue;
            return ie.getPropertyFinder();
        }
        return null;
    }

    protected abstract boolean indexMatches(PropertyMeta<T, ?> var1, PropertyMeta<?, ?> var2);

    @Override
    public PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        PropertyMeta<?, ?> ownerProperty = subPropertyMeta.getOwnerProperty();
        PropertyFinder<?> ie = this.lookForPropertyFinder(ownerProperty);
        if (ie != null) {
            return ie;
        }
        return this.registerProperty(subPropertyMeta);
    }

    protected abstract PropertyFinder<?> registerProperty(SubPropertyMeta<?, ?, ?> var1);
}

