/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.asm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.simpleflatmapper.ow2asm.ClassWriter;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.ow2asm.Opcodes;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.asm.AsmUtils;
import org.simpleflatmapper.reflect.primitive.IntSetter;

public class SetterBuilder
implements Opcodes {
    private static final String SETTER_TYPE = AsmUtils.toAsmType(Setter.class);
    private static final String ORG_SFM_REFLECT_PRIMITIVE = AsmUtils.toAsmType(IntSetter.class.getPackage().getName());

    public static byte[] createObjectSetter(String className, Field field) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class<?> target = field.getDeclaringClass();
        Class<?> property = field.getType();
        String targetType = SetterBuilder.toType(target);
        String propertyType = SetterBuilder.toType(property);
        String classType = SetterBuilder.toType(className);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + SETTER_TYPE + "<L" + targetType + ";" + AsmUtils.toTargetTypeDeclaration(propertyType) + ">;", "java/lang/Object", new String[]{SETTER_TYPE});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        SetterBuilder.appendSet(field, cw, target, targetType, propertyType, classType);
        SetterBuilder.appendToString(cw);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    public static byte[] createObjectSetter(String className, Method method) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class<?> target = method.getDeclaringClass();
        Class<?> property = method.getParameterTypes()[0];
        String targetType = SetterBuilder.toType(target);
        String propertyType = SetterBuilder.toType(property);
        String classType = SetterBuilder.toType(className);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + SETTER_TYPE + "<L" + targetType + ";" + AsmUtils.toTargetTypeDeclaration(propertyType) + ">;", "java/lang/Object", new String[]{SETTER_TYPE});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        SetterBuilder.appendSet(method, cw, target, targetType, propertyType, classType);
        SetterBuilder.appendToString(cw);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    private static void appendSet(Field field, ClassWriter cw, Class<?> target, String targetType, String propertyType, String classType) {
        MethodVisitor mv = cw.visitMethod(1, "set", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + AsmUtils.toTargetTypeDeclaration(propertyType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, targetType, field.getName(), AsmUtils.toTargetTypeDeclaration(propertyType));
        mv.visitInsn(177);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        SetterBuilder.appendSynthetic(cw, targetType, propertyType, classType);
    }

    private static void appendSet(Method method, ClassWriter cw, Class<?> target, String targetType, String propertyType, String classType) {
        MethodVisitor mv = cw.visitMethod(1, "set", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + AsmUtils.toTargetTypeDeclaration(propertyType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        AsmUtils.invoke(mv, target, method.getName(), "(" + AsmUtils.toTargetTypeDeclaration(propertyType) + ")" + AsmUtils.toTargetTypeDeclaration(method.getReturnType()));
        mv.visitInsn(177);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        SetterBuilder.appendSynthetic(cw, targetType, propertyType, classType);
    }

    private static void appendSynthetic(ClassWriter cw, String targetType, String propertyType, String classType) {
        MethodVisitor mv = cw.visitMethod(4161, "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, targetType);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, propertyType);
        mv.visitMethodInsn(182, classType, "set", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + AsmUtils.toTargetTypeDeclaration(propertyType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    private static void appendToString(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitMethodInsn(182, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn("{");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn("}");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    public static byte[] createPrimitiveSetter(String className, Method method) throws Exception {
        String valueMethodPrefix;
        ClassWriter cw = new ClassWriter(1);
        Class<?> target = method.getDeclaringClass();
        Class<?> primitive = method.getParameterTypes()[0];
        Class<?> property = AsmUtils.wrappers.get(primitive);
        String targetType = SetterBuilder.toType(target);
        String primitiveType = AsmUtils.primitivesType.get(primitive);
        String propertyType = SetterBuilder.toType(property);
        String classType = SetterBuilder.toType(className);
        String methodSuffix = property.getSimpleName();
        if ("Integer".equals(methodSuffix)) {
            methodSuffix = "Int";
        }
        if ("character".equals(valueMethodPrefix = methodSuffix.toLowerCase())) {
            valueMethodPrefix = "char";
        }
        String setMethod = "set" + methodSuffix;
        String valueMethod = valueMethodPrefix + "Value";
        int primitiveLoadOp = AsmUtils.loadOps.get(primitive);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + SETTER_TYPE + "<L" + targetType + ";" + AsmUtils.toTargetTypeDeclaration(propertyType) + ">;L" + ORG_SFM_REFLECT_PRIMITIVE + methodSuffix + "Setter<L" + targetType + ";>;", "java/lang/Object", new String[]{SETTER_TYPE, ORG_SFM_REFLECT_PRIMITIVE + "/" + methodSuffix + "Setter"});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, setMethod, "(" + AsmUtils.toTargetTypeDeclaration(targetType) + primitiveType + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(primitiveLoadOp, 2);
        AsmUtils.invoke(mv, target, method.getName(), "(" + primitiveType + ")" + AsmUtils.toTargetTypeDeclaration(method.getReturnType()));
        mv.visitInsn(177);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "set", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + AsmUtils.toTargetTypeDeclaration(propertyType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        AsmUtils.invoke(mv, property, valueMethod, "()" + primitiveType);
        AsmUtils.invoke(mv, target, method.getName(), "(" + primitiveType + ")" + AsmUtils.toTargetTypeDeclaration(method.getReturnType()));
        mv.visitInsn(177);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        SetterBuilder.appendPrimitiveSynthetic(cw, targetType, primitiveType, propertyType, classType, setMethod, primitiveLoadOp);
        SetterBuilder.appendToString(cw);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    public static byte[] createPrimitiveSetter(String className, Field field) throws Exception {
        String valueMethodPrefix;
        ClassWriter cw = new ClassWriter(1);
        Class<?> target = field.getDeclaringClass();
        Class<?> primitive = field.getType();
        Class<?> property = AsmUtils.wrappers.get(primitive);
        String targetType = SetterBuilder.toType(target);
        String primitiveType = AsmUtils.primitivesType.get(primitive);
        String propertyType = SetterBuilder.toType(property);
        String classType = SetterBuilder.toType(className);
        String methodSuffix = property.getSimpleName();
        if ("Integer".equals(methodSuffix)) {
            methodSuffix = "Int";
        }
        if ("character".equals(valueMethodPrefix = methodSuffix.toLowerCase())) {
            valueMethodPrefix = "char";
        }
        String setMethod = "set" + methodSuffix;
        String valueMethod = valueMethodPrefix + "Value";
        int primitiveLoadOp = AsmUtils.loadOps.get(primitive);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + SETTER_TYPE + "<L" + targetType + ";" + AsmUtils.toTargetTypeDeclaration(propertyType) + ">;L" + ORG_SFM_REFLECT_PRIMITIVE + methodSuffix + "Setter<L" + targetType + ";>;", "java/lang/Object", new String[]{SETTER_TYPE, ORG_SFM_REFLECT_PRIMITIVE + "/" + methodSuffix + "Setter"});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, setMethod, "(" + AsmUtils.toTargetTypeDeclaration(targetType) + primitiveType + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(primitiveLoadOp, 2);
        mv.visitFieldInsn(181, targetType, field.getName(), primitiveType);
        mv.visitInsn(177);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "set", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + AsmUtils.toTargetTypeDeclaration(propertyType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        AsmUtils.invoke(mv, property, valueMethod, "()" + primitiveType);
        mv.visitFieldInsn(181, targetType, field.getName(), primitiveType);
        mv.visitInsn(177);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        SetterBuilder.appendPrimitiveSynthetic(cw, targetType, primitiveType, propertyType, classType, setMethod, primitiveLoadOp);
        SetterBuilder.appendToString(cw);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    private static void appendPrimitiveSynthetic(ClassWriter cw, String targetType, String primitiveType, String propertyType, String classType, String setMethod, int primitiveLoadOp) {
        MethodVisitor mv = cw.visitMethod(4161, setMethod, "(Ljava/lang/Object;" + primitiveType + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, targetType);
        mv.visitVarInsn(primitiveLoadOp, 2);
        mv.visitMethodInsn(182, classType, setMethod, "(" + AsmUtils.toTargetTypeDeclaration(targetType) + primitiveType + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, targetType);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, propertyType);
        mv.visitMethodInsn(182, classType, "set", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + AsmUtils.toTargetTypeDeclaration(propertyType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    private static String toType(Class<?> target) {
        String name = target.getName();
        return SetterBuilder.toType(name);
    }

    private static String toType(String name) {
        return name.replace('.', '/');
    }
}

