/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.lang.reflect.Method;
import java.util.Map;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;

public final class BuilderInstantiatorDefinition
implements InstantiatorDefinition {
    private final InstantiatorDefinition builderInstantiator;
    private final Map<Parameter, Method> setters;
    private final Method buildMethod;

    public BuilderInstantiatorDefinition(InstantiatorDefinition builderInstantiator, Map<Parameter, Method> setters, Method buildMethod) {
        this.builderInstantiator = builderInstantiator;
        this.setters = setters;
        this.buildMethod = buildMethod;
    }

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[this.setters.size()];
        int i = 0;
        for (Parameter p : this.setters.keySet()) {
            parameters[i++] = p;
        }
        return parameters;
    }

    public InstantiatorDefinition getBuilderInstantiator() {
        return this.builderInstantiator;
    }

    public Map<Parameter, Method> getSetters() {
        return this.setters;
    }

    public Method getBuildMethod() {
        return this.buildMethod;
    }

    @Override
    public boolean hasParam(Parameter param) {
        return this.setters.containsKey(param);
    }

    @Override
    public InstantiatorDefinition.Type getType() {
        return InstantiatorDefinition.Type.BUILDER;
    }

    @Override
    public String getName() {
        return this.buildMethod.getDeclaringClass().getName();
    }
}

