/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.asm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.simpleflatmapper.ow2asm.ClassWriter;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.ow2asm.Opcodes;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.asm.AsmUtils;
import org.simpleflatmapper.reflect.primitive.IntGetter;

public class GetterBuilder
implements Opcodes {
    private static final String GETTER_TYPE = AsmUtils.toAsmType(Getter.class);
    private static final String ORG_SFM_REFLECT_PRIMITIVE = AsmUtils.toAsmType(IntGetter.class.getPackage().getName());

    public static byte[] createObjectGetter(String className, Field field) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class<?> target = field.getDeclaringClass();
        Class<?> property = field.getType();
        String targetType = GetterBuilder.toType(target);
        String propertyType = GetterBuilder.toType(property);
        String classType = GetterBuilder.toType(className);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + GETTER_TYPE + "<L" + targetType + ";" + AsmUtils.toTargetTypeDeclaration(propertyType) + ">;", "java/lang/Object", new String[]{GETTER_TYPE});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "get", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + ")" + AsmUtils.toTargetTypeDeclaration(propertyType), null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(180, targetType, field.getName(), AsmUtils.toTargetTypeDeclaration(propertyType));
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        GetterBuilder.appendBridge(cw, targetType, propertyType, classType);
        GetterBuilder.appendToString(cw);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    public static byte[] createObjectGetter(String className, Method method) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class<?> target = method.getDeclaringClass();
        Class<?> property = method.getReturnType();
        String targetType = GetterBuilder.toType(target);
        String propertyType = GetterBuilder.toType(property);
        String classType = GetterBuilder.toType(className);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + GETTER_TYPE + "<L" + targetType + ";" + AsmUtils.toTargetTypeDeclaration(propertyType) + ">;", "java/lang/Object", new String[]{GETTER_TYPE});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "get", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + ")" + AsmUtils.toTargetTypeDeclaration(propertyType), null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        AsmUtils.invoke(mv, target, method.getName(), "()" + AsmUtils.toTargetTypeDeclaration(propertyType));
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        GetterBuilder.appendBridge(cw, targetType, propertyType, classType);
        GetterBuilder.appendToString(cw);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    private static void appendBridge(ClassWriter cw, String targetType, String propertyType, String classType) {
        MethodVisitor mv = cw.visitMethod(4161, "get", "(Ljava/lang/Object;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, targetType);
        mv.visitMethodInsn(182, classType, "get", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + ")" + AsmUtils.toTargetTypeDeclaration(propertyType), false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    public static byte[] createPrimitiveGetter(String className, Field field) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class<?> target = field.getDeclaringClass();
        Class<?> primitive = field.getType();
        Class<?> property = AsmUtils.wrappers.get(primitive);
        String targetType = GetterBuilder.toType(target);
        String primitiveType = AsmUtils.primitivesType.get(primitive);
        String propertyType = GetterBuilder.toType(property);
        String classType = GetterBuilder.toType(className);
        String methodSuffix = property.getSimpleName();
        if ("Integer".equals(methodSuffix)) {
            methodSuffix = "Int";
        }
        String getMethod = "get" + methodSuffix;
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + GETTER_TYPE + "<L" + targetType + ";" + AsmUtils.toTargetTypeDeclaration(propertyType) + ">;L" + ORG_SFM_REFLECT_PRIMITIVE + methodSuffix + "Getter<L" + targetType + ";>;", "java/lang/Object", new String[]{GETTER_TYPE, ORG_SFM_REFLECT_PRIMITIVE + "/" + methodSuffix + "Getter"});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, getMethod, "(" + AsmUtils.toTargetTypeDeclaration(targetType) + ")" + primitiveType, null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(180, targetType, field.getName(), primitiveType);
        mv.visitInsn(AsmUtils.returnOps.get(primitive));
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "get", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + ")" + AsmUtils.toTargetTypeDeclaration(propertyType), null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(180, targetType, field.getName(), primitiveType);
        mv.visitMethodInsn(184, propertyType, "valueOf", "(" + primitiveType + ")L" + propertyType + ";", false);
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        GetterBuilder.appendPrimitiveBridges(cw, primitive, targetType, primitiveType, propertyType, classType, getMethod);
        GetterBuilder.appendToString(cw);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    public static byte[] createPrimitiveGetter(String className, Method method) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class<?> target = method.getDeclaringClass();
        Class<?> primitive = method.getReturnType();
        Class<?> property = AsmUtils.wrappers.get(primitive);
        String targetType = GetterBuilder.toType(target);
        String primitiveType = AsmUtils.primitivesType.get(primitive);
        String propertyType = GetterBuilder.toType(property);
        String classType = GetterBuilder.toType(className);
        String methodSuffix = property.getSimpleName();
        if ("Integer".equals(methodSuffix)) {
            methodSuffix = "Int";
        }
        String getMethod = "get" + methodSuffix;
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + GETTER_TYPE + "<L" + targetType + ";" + AsmUtils.toTargetTypeDeclaration(propertyType) + ">;L" + ORG_SFM_REFLECT_PRIMITIVE + methodSuffix + "Getter<L" + targetType + ";>;", "java/lang/Object", new String[]{GETTER_TYPE, ORG_SFM_REFLECT_PRIMITIVE + "/" + methodSuffix + "Getter"});
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, getMethod, "(" + AsmUtils.toTargetTypeDeclaration(targetType) + ")" + primitiveType, null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        AsmUtils.invoke(mv, target, method.getName(), "()" + primitiveType);
        mv.visitInsn(AsmUtils.returnOps.get(primitive));
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "get", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + ")" + AsmUtils.toTargetTypeDeclaration(propertyType), null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        AsmUtils.invoke(mv, target, method.getName(), "()" + primitiveType);
        mv.visitMethodInsn(184, propertyType, "valueOf", "(" + primitiveType + ")L" + propertyType + ";", false);
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        GetterBuilder.appendPrimitiveBridges(cw, primitive, targetType, primitiveType, propertyType, classType, getMethod);
        GetterBuilder.appendToString(cw);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    private static void appendPrimitiveBridges(ClassWriter cw, Class<?> primitive, String targetType, String primitiveType, String propertyType, String classType, String getMethod) {
        MethodVisitor mv = cw.visitMethod(4161, getMethod, "(Ljava/lang/Object;)" + primitiveType, null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, targetType);
        mv.visitMethodInsn(182, classType, getMethod, "(" + AsmUtils.toTargetTypeDeclaration(targetType) + ")" + primitiveType, false);
        mv.visitInsn(AsmUtils.returnOps.get(primitive));
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "get", "(Ljava/lang/Object;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, targetType);
        mv.visitMethodInsn(182, classType, "get", "(" + AsmUtils.toTargetTypeDeclaration(targetType) + ")" + AsmUtils.toTargetTypeDeclaration(propertyType), false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static void appendToString(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitMethodInsn(182, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn("{");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn("}");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private static String toType(Class<?> target) {
        String name = target.getName();
        return GetterBuilder.toType(name);
    }

    private static String toType(String name) {
        return name.replace('.', '/');
    }
}

