/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.MapElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcherKeyValuePair;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.Predicate;

public class MapPropertyFinder<T extends Map<K, V>, K, V>
extends PropertyFinder<T> {
    private final ClassMeta<V> valueMetaData;
    private final ClassMeta<T> mapMeta;
    private final Converter<? super CharSequence, ? extends K> keyConverter;
    private final Map<PropertyNameMatcher, PropertyFinder<V>> finders = new HashMap<PropertyNameMatcher, PropertyFinder<V>>();
    private final Map<PropertyMeta<?, ?>, PropertyFinder<V>> findersByKey = new HashMap();
    private final Map<String, MapElementPropertyMeta<?, K, V>> keys = new HashMap();

    public MapPropertyFinder(ClassMeta<T> mapMeta, ClassMeta<V> valueMetaData, Converter<? super CharSequence, ? extends K> keyConverter, Predicate<PropertyMeta<?, ?>> propertyFilter) {
        super(propertyFilter);
        this.mapMeta = mapMeta;
        this.valueMetaData = valueMetaData;
        this.keyConverter = keyConverter;
    }

    @Override
    public void lookForProperties(PropertyNameMatcher propertyNameMatcher, final PropertyFinder.FoundProperty matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer) {
        for (PropertyNameMatcherKeyValuePair keyValue : propertyNameMatcher.keyValuePairs()) {
            final PropertyNameMatcher keyMatcher = keyValue.getKey();
            PropertyNameMatcher valueMatcher = keyValue.getValue();
            final PropertyFinder<V> propertyFinder = this.getPropertyFinder(keyMatcher);
            propertyFinderTransformer.apply(propertyFinder).lookForProperties(valueMatcher, new PropertyFinder.FoundProperty<V>(){

                @Override
                public <P extends PropertyMeta<V, ?>> void found(P propertyMeta, final Runnable selectionCallback, PropertyMatchingScore score) {
                    final PropertyMeta keyProperty = MapPropertyFinder.this.keyProperty(keyMatcher);
                    Runnable sCallback = new Runnable(){

                        @Override
                        public void run() {
                            MapPropertyFinder.this.finders.put(keyMatcher, propertyFinder);
                            MapPropertyFinder.this.findersByKey.put(keyProperty, propertyFinder);
                            selectionCallback.run();
                        }
                    };
                    if (keyProperty != null) {
                        if (propertyMeta instanceof SelfPropertyMeta) {
                            matchingProperties.found(keyProperty, sCallback, score);
                        } else {
                            matchingProperties.found(MapPropertyFinder.this.newSubPropertyMeta(keyProperty, propertyMeta), sCallback, score);
                        }
                    }
                }
            }, score, true, propertyFinderTransformer);
        }
    }

    private PropertyFinder<V> getPropertyFinder(PropertyNameMatcher keyMatcher) {
        PropertyFinder<V> propertyFinder = this.finders.get(keyMatcher);
        if (propertyFinder == null) {
            propertyFinder = this.valueMetaData.newPropertyFinder(this.propertyFilter);
        }
        return propertyFinder;
    }

    private <E> PropertyMeta<T, E> newSubPropertyMeta(PropertyMeta<T, ?> keyProperty, PropertyMeta<V, ?> propertyMeta) {
        return new SubPropertyMeta(this.valueMetaData.getReflectionService(), keyProperty, propertyMeta);
    }

    private <E> PropertyMeta<T, E> keyProperty(PropertyNameMatcher propertyNameMatcher) {
        String keyStringValue = propertyNameMatcher.toString();
        MapElementPropertyMeta propertyMeta = this.keys.get(keyStringValue);
        if (propertyMeta == null) {
            Object key;
            try {
                key = this.keyConverter.convert((Object)keyStringValue);
            }
            catch (Exception e) {
                return null;
            }
            MapElementPropertyMeta mapElementPropertyMeta = new MapElementPropertyMeta(propertyNameMatcher, this.mapMeta.getType(), this.valueMetaData.getReflectionService(), this.valueMetaData, key);
            this.keys.put(keyStringValue, mapElementPropertyMeta);
            propertyMeta = mapElementPropertyMeta;
        }
        return propertyMeta;
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.mapMeta.getInstantiatorDefinitions();
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> owner) {
        return this.findersByKey.get(owner);
    }

    @Override
    public PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        return this.getSubPropertyFinder(subPropertyMeta.getOwnerProperty());
    }

    @Override
    public Type getOwnerType() {
        return this.mapMeta.getType();
    }
}

