/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.BooleanProvider;
import org.simpleflatmapper.util.Predicate;

final class ObjectPropertyFinder<T>
extends PropertyFinder<T> {
    private final List<InstantiatorDefinition> eligibleInstantiatorDefinitions;
    private final ObjectClassMeta<T> classMeta;
    private final Map<PropertyMeta<?, ?>, PropertyFinder<?>> subPropertyFinders = new HashMap();
    private State state = State.NONE;
    private String selfName;

    ObjectPropertyFinder(ObjectClassMeta<T> classMeta, Predicate<PropertyMeta<?, ?>> propertyFilter) {
        super(propertyFilter);
        this.classMeta = classMeta;
        this.eligibleInstantiatorDefinitions = classMeta.getInstantiatorDefinitions() != null ? new ArrayList<InstantiatorDefinition>(classMeta.getInstantiatorDefinitions()) : null;
    }

    @Override
    public void lookForProperties(PropertyNameMatcher propertyNameMatcher, PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinder.PropertyFinderTransformer propertyFinderTransform) {
        this.lookForConstructor(propertyNameMatcher, matchingProperties, score, propertyFinderTransform);
        this.lookForProperty(propertyNameMatcher, matchingProperties, score, propertyFinderTransform);
        String propName = propertyNameMatcher.toString();
        if (allowSelfReference && (this.state == State.NONE || this.state == State.SELF && propName.equals(this.selfName))) {
            matchingProperties.found(new SelfPropertyMeta(this.classMeta.getReflectionService(), this.classMeta.getType(), new BooleanProvider(){

                public boolean getBoolean() {
                    return ObjectPropertyFinder.this.state != State.PROPERTIES;
                }
            }), this.selfPropertySelectionCallback(propName), PropertyMatchingScore.MINIMUM);
        }
    }

    private void lookForConstructor(PropertyNameMatcher propertyNameMatcher, final PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer) {
        if (this.classMeta.getConstructorProperties() != null) {
            for (final ConstructorPropertyMeta<T, ?> prop : this.classMeta.getConstructorProperties()) {
                PropertyNameMatcher subPropMatcher;
                String columnName = this.getColumnName(prop);
                if (propertyNameMatcher.matches(columnName) && this.hasConstructorMatching(prop.getParameter())) {
                    matchingProperties.found(prop, this.propertiesRemoveNonMatchingCallBack(prop), score);
                }
                if ((subPropMatcher = propertyNameMatcher.partialMatch(columnName)) == null || !this.hasConstructorMatching(prop.getParameter())) continue;
                this.lookForSubProperty(subPropMatcher, prop, new PropertyFinder.FoundProperty(){

                    public void found(PropertyMeta propertyMeta, Runnable selectionCallback, PropertyMatchingScore score) {
                        matchingProperties.found(new SubPropertyMeta(ObjectPropertyFinder.this.classMeta.getReflectionService(), prop, propertyMeta), ObjectPropertyFinder.this.propertiesDelegateAndRemoveNonMatchingCallBack(selectionCallback, prop), score.shift());
                    }
                }, score.shift(), propertyFinderTransformer);
            }
        }
    }

    private void lookForProperty(PropertyNameMatcher propertyNameMatcher, final PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer) {
        for (final PropertyMeta<T, ?> prop : this.classMeta.getProperties()) {
            PropertyNameMatcher subPropMatcher;
            String columnName = this.getColumnName(prop);
            if (propertyNameMatcher.matches(columnName)) {
                matchingProperties.found(prop, this.propertiesCallBack(), score.decrease(1));
            }
            if ((subPropMatcher = propertyNameMatcher.partialMatch(columnName)) == null) continue;
            this.lookForSubProperty(subPropMatcher, prop, new PropertyFinder.FoundProperty(){

                public void found(PropertyMeta propertyMeta, Runnable selectionCallback, PropertyMatchingScore score) {
                    matchingProperties.found(new SubPropertyMeta(ObjectPropertyFinder.this.classMeta.getReflectionService(), prop, propertyMeta), ObjectPropertyFinder.this.propertiesDelegateCallBack(selectionCallback), score);
                }
            }, score.shift().decrease(-1), propertyFinderTransformer);
        }
    }

    private void lookForSubProperty(PropertyNameMatcher propertyNameMatcher, final PropertyMeta<T, ?> prop, final PropertyFinder.FoundProperty foundProperty, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer) {
        PropertyFinder<?> subPropertyFinder = this.subPropertyFinders.get(prop);
        final PropertyFinder<?> newPropertyFinder = subPropertyFinder == null ? (subPropertyFinder = prop.getPropertyClassMeta().newPropertyFinder(this.propertyFilter)) : null;
        propertyFinderTransformer.apply(subPropertyFinder).lookForProperties(propertyNameMatcher, new PropertyFinder.FoundProperty(){

            public void found(PropertyMeta propertyMeta, Runnable selectionCallback, PropertyMatchingScore score) {
                if (newPropertyFinder != null) {
                    ObjectPropertyFinder.this.subPropertyFinders.put(prop, newPropertyFinder);
                }
                foundProperty.found(propertyMeta, selectionCallback, score);
            }
        }, score, false, propertyFinderTransformer);
    }

    private String getColumnName(PropertyMeta<T, ?> prop) {
        return this.classMeta.getAlias(prop.getName());
    }

    private void removeNonMatching(Parameter param) {
        ListIterator<InstantiatorDefinition> li = this.eligibleInstantiatorDefinitions.listIterator();
        while (li.hasNext()) {
            InstantiatorDefinition cd = li.next();
            if (cd.hasParam(param)) continue;
            li.remove();
        }
    }

    private boolean hasConstructorMatching(Parameter param) {
        for (InstantiatorDefinition cd : this.eligibleInstantiatorDefinitions) {
            if (!cd.hasParam(param)) continue;
            return true;
        }
        return false;
    }

    private Runnable compose(final Runnable r1, final Runnable r2) {
        return new Runnable(){

            @Override
            public void run() {
                r1.run();
                r2.run();
            }
        };
    }

    private Runnable propertiesDelegateAndRemoveNonMatchingCallBack(Runnable selectionCallback, ConstructorPropertyMeta<T, ?> prop) {
        return this.compose(selectionCallback, this.propertiesRemoveNonMatchingCallBack(prop));
    }

    private Runnable propertiesRemoveNonMatchingCallBack(ConstructorPropertyMeta<T, ?> prop) {
        return this.compose(this.removeNonMatchingCallBack(prop), this.propertiesCallBack());
    }

    private Runnable removeNonMatchingCallBack(final ConstructorPropertyMeta<T, ?> prop) {
        return new Runnable(){

            @Override
            public void run() {
                ObjectPropertyFinder.this.removeNonMatching(prop.getParameter());
            }
        };
    }

    private Runnable propertiesDelegateCallBack(Runnable selectionCallback) {
        return this.compose(selectionCallback, this.propertiesCallBack());
    }

    private Runnable propertiesCallBack() {
        return new Runnable(){

            @Override
            public void run() {
                ObjectPropertyFinder.this.state = State.PROPERTIES;
            }
        };
    }

    private Runnable selfPropertySelectionCallback(final String propName) {
        return new Runnable(){

            @Override
            public void run() {
                ObjectPropertyFinder.this.state = State.SELF;
                ObjectPropertyFinder.this.selfName = propName;
            }
        };
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.eligibleInstantiatorDefinitions;
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> owner) {
        return this.subPropertyFinders.get(owner);
    }

    @Override
    public PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        PropertyFinder<?> propertyFinder = this.subPropertyFinders.get(subPropertyMeta.getOwnerProperty());
        if (propertyFinder == null) {
            propertyFinder = subPropertyMeta.getSubProperty().getPropertyClassMeta().newPropertyFinder(this.propertyFilter);
            this.subPropertyFinders.put(subPropertyMeta.getOwnerProperty(), propertyFinder);
        }
        return propertyFinder;
    }

    @Override
    public Type getOwnerType() {
        return this.classMeta.getType();
    }

    @Override
    public void manualMatch(PropertyMeta<?, ?> prop) {
        if (prop.isConstructorProperty()) {
            this.removeNonMatching(((ConstructorPropertyMeta)prop).getParameter());
        }
        super.manualMatch(prop);
    }

    static enum State {
        NONE,
        SELF,
        PROPERTIES;

    }
}

