/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.ObjectGetterFactory;
import org.simpleflatmapper.reflect.ObjectSetterFactory;
import org.simpleflatmapper.reflect.ReflectionInstantiatorDefinitionFactory;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.asm.AsmInstantiatorDefinitionFactory;
import org.simpleflatmapper.reflect.impl.BuilderInstantiatorDefinitionFactory;
import org.simpleflatmapper.reflect.impl.JavaLangClassMetaFactoryProducer;
import org.simpleflatmapper.reflect.instantiator.InstantiatorDefinitions;
import org.simpleflatmapper.reflect.meta.AliasProvider;
import org.simpleflatmapper.reflect.meta.AliasProviderService;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.FastTupleClassMeta;
import org.simpleflatmapper.reflect.meta.MapClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.OptionalClassMeta;
import org.simpleflatmapper.reflect.meta.TupleClassMeta;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ProducerServiceLoader;
import org.simpleflatmapper.util.TupleHelper;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public class ReflectionService {
    private static final UnaryFactory<ReflectionService, ClassMeta<?>>[] predefined = ReflectionService.getPredifinedClassMetaFactory();
    private final ObjectSetterFactory objectSetterFactory;
    private final ObjectGetterFactory objectGetterFactory;
    private final InstantiatorFactory instantiatorFactory;
    private final AsmFactory asmFactory;
    private final AliasProvider aliasProvider;
    private final boolean builderIgnoresNullValues;
    private final ConcurrentMap<Type, ClassMeta<?>> metaCache = new ConcurrentHashMap();
    private static final AsmFactory _asmFactory = new AsmFactory(Thread.currentThread().getContextClassLoader());

    private static UnaryFactory<ReflectionService, ClassMeta<?>>[] getPredifinedClassMetaFactory() {
        final ArrayList list = new ArrayList();
        Consumer consumer = new Consumer<UnaryFactory<ReflectionService, ClassMeta<?>>>(){

            public void accept(UnaryFactory<ReflectionService, ClassMeta<?>> reflectionServiceClassMetaUnaryFactory) {
                list.add(reflectionServiceClassMetaUnaryFactory);
            }
        };
        new JavaLangClassMetaFactoryProducer().produce(consumer);
        ProducerServiceLoader.produceFromServiceLoader(ClassMetaFactoryProducer.class, (Consumer)consumer);
        return list.toArray(new UnaryFactory[0]);
    }

    public ReflectionService(AsmFactory asmFactory) {
        this(new ObjectSetterFactory(asmFactory), new ObjectGetterFactory(asmFactory), new InstantiatorFactory(asmFactory), asmFactory, AliasProviderService.getAliasProvider(), true);
    }

    private ReflectionService(ObjectSetterFactory objectSetterFactory, ObjectGetterFactory objectGetterFactory, InstantiatorFactory instantiatorFactory, AsmFactory asmFactory, AliasProvider aliasProvider, boolean builderIgnoresNullValues) {
        this.objectSetterFactory = objectSetterFactory;
        this.objectGetterFactory = objectGetterFactory;
        this.instantiatorFactory = instantiatorFactory;
        this.asmFactory = asmFactory;
        this.aliasProvider = aliasProvider;
        this.builderIgnoresNullValues = builderIgnoresNullValues;
        this.initPredefined();
    }

    private void initPredefined() {
        for (UnaryFactory<ReflectionService, ClassMeta<?>> factory : predefined) {
            ClassMeta classMeta = (ClassMeta)factory.newInstance((Object)this);
            this.metaCache.put(classMeta.getType(), classMeta);
        }
    }

    public ObjectSetterFactory getObjectSetterFactory() {
        return this.objectSetterFactory;
    }

    public InstantiatorFactory getInstantiatorFactory() {
        return this.instantiatorFactory;
    }

    public boolean isAsmActivated() {
        return this.asmFactory != null;
    }

    public AsmFactory getAsmFactory() {
        return this.asmFactory;
    }

    public <T> ClassMeta<T> getClassMeta(Class<T> target) {
        return this.getClassMeta((Type)target);
    }

    public <T> ClassMeta<T> getClassMeta(Type target) {
        Asserts.requireNonNull((String)"target", (Object)target);
        ClassMeta<T> meta = (ClassMeta<T>)this.metaCache.get(target);
        if (meta == null) {
            meta = this.newClassMeta(target);
            Asserts.requireNonNull((String)"meta", meta);
            this.metaCache.putIfAbsent(target, meta);
        }
        return meta;
    }

    private <T> ClassMeta<T> newClassMeta(Type target) {
        Class clazz = TypeHelper.toClass((Type)target);
        if (clazz.isArray()) {
            return this.newArrayMeta(clazz);
        }
        if (Optional.class.isAssignableFrom(clazz)) {
            return new OptionalClassMeta(target, this);
        }
        if (TupleHelper.isTuple((Type)target)) {
            return new TupleClassMeta(target, this);
        }
        if (this.isFastTuple(clazz)) {
            return new FastTupleClassMeta(target, this);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.newMapMeta(target);
        }
        if (Collection.class.isAssignableFrom(clazz) || Iterable.class.equals((Object)clazz)) {
            return this.newCollectionMeta(target);
        }
        return new ObjectClassMeta(target, this);
    }

    public <T> ClassMeta<T> getClassMetaExtraInstantiator(Type target, Member builderInstantiator) {
        return new ObjectClassMeta(target, builderInstantiator, this);
    }

    private <K, V> ClassMeta<Map<K, V>> newMapMeta(Type type) {
        TypeHelper.MapEntryTypes types = TypeHelper.getKeyValueTypeOfMap((Type)type);
        return new MapClassMeta(type, types.getKeyType(), types.getValueType(), this);
    }

    private <T, E> ClassMeta<T> newArrayMeta(Class<T> clazz) {
        return new ArrayClassMeta(clazz, clazz.getComponentType(), this);
    }

    private <T, E> ClassMeta<T> newCollectionMeta(Type type) {
        return new ArrayClassMeta(type, TypeHelper.getComponentTypeOfListOrArray((Type)type), this);
    }

    private <T> boolean isFastTuple(Class<T> clazz) {
        Class<T> superClass = clazz.getSuperclass();
        return superClass != null && "com.boundary.tuple.FastTuple".equals(superClass.getName());
    }

    public String getColumnName(Method method) {
        return this.aliasProvider.getAliasForMethod(method);
    }

    public String getColumnName(Field field) {
        return this.aliasProvider.getAliasForField(field);
    }

    public List<InstantiatorDefinition> extractInstantiator(Type target) throws IOException {
        return this.extractInstantiator(target, null);
    }

    public List<InstantiatorDefinition> extractInstantiator(Type target, Member extraInstantiator) throws IOException {
        List<InstantiatorDefinition> list;
        if (!ReflectionInstantiatorDefinitionFactory.areParameterNamePresent(target)) {
            try {
                list = AsmInstantiatorDefinitionFactory.extractDefinitions(target);
            }
            catch (IOException e) {
                list = ReflectionInstantiatorDefinitionFactory.extractDefinitions(target);
            }
        } else {
            list = ReflectionInstantiatorDefinitionFactory.extractDefinitions(target);
        }
        if (extraInstantiator == null) {
            list.addAll(BuilderInstantiatorDefinitionFactory.extractDefinitions(target));
        } else if (extraInstantiator instanceof Method && TypeHelper.areEquals((Type)target, (Type)((Method)extraInstantiator).getGenericReturnType())) {
            list.add(ReflectionInstantiatorDefinitionFactory.definition((Method)extraInstantiator));
        } else {
            BuilderInstantiatorDefinition builder = BuilderInstantiatorDefinitionFactory.getDefinitionForBuilder(extraInstantiator, target);
            if (builder == null) {
                throw new IllegalArgumentException("Could not find any setters or build method on builder " + extraInstantiator);
            }
            list.add(builder);
        }
        Collections.sort(list, InstantiatorDefinitions.COMPARATOR);
        return list;
    }

    public static ReflectionService newInstance() {
        return ReflectionService.newInstance(true);
    }

    public static ReflectionService newInstance(boolean useAsmGeneration) {
        return new ReflectionService(useAsmGeneration && ReflectionService.canSeeSetterFromContextClassLoader() ? _asmFactory : null);
    }

    public static ReflectionService disableAsm() {
        return ReflectionService.newInstance(false);
    }

    private static boolean canSeeSetterFromContextClassLoader() {
        try {
            Class.forName(Setter.class.getName(), false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ObjectGetterFactory getObjectGetterFactory() {
        return this.objectGetterFactory;
    }

    public boolean hasAsmFactory() {
        return this.asmFactory != null;
    }

    public ReflectionService withAliasProvider(AliasProvider aliasProvider) {
        return new ReflectionService(this.objectSetterFactory, this.objectGetterFactory, this.instantiatorFactory, this.asmFactory, aliasProvider, this.builderIgnoresNullValues);
    }

    public ReflectionService withBuilderIgnoresNullValues(boolean builderIgnoresNullValues) {
        return new ReflectionService(this.objectSetterFactory, this.objectGetterFactory, this.instantiatorFactory, this.asmFactory, this.aliasProvider, builderIgnoresNullValues);
    }

    public boolean builderIgnoresNullValues() {
        return this.builderIgnoresNullValues;
    }

    public static interface ClassMetaFactoryProducer
    extends ProducerServiceLoader.Producer<UnaryFactory<ReflectionService, ClassMeta<?>>> {
    }
}

