/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatch;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.Predicate;

public abstract class AbstractIndexPropertyFinder<T>
extends PropertyFinder<T> {
    protected final ClassMeta<T> classMeta;
    protected final List<IndexedElement<T, ?>> elements = new ArrayList();

    public AbstractIndexPropertyFinder(ClassMeta<T> classMeta, Predicate<PropertyMeta<?, ?>> propertyFilter) {
        super(propertyFilter);
        this.classMeta = classMeta;
    }

    @Override
    public void lookForProperties(PropertyNameMatcher propertyNameMatcher, PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer) {
        IndexedColumn indexedColumn = propertyNameMatcher.matchIndex();
        if (indexedColumn != null) {
            this.lookForAgainstColumn(indexedColumn, matchingProperties, score, propertyFinderTransformer);
        } else {
            this.extrapolateIndex(propertyNameMatcher, matchingProperties, score.decrease(1), propertyFinderTransformer);
            this.speculativeMatching(propertyNameMatcher, matchingProperties, score.shift(), propertyFinderTransformer);
        }
    }

    protected void lookForAgainstColumn(IndexedColumn indexedColumn, final PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer) {
        if (indexedColumn == null || !this.isValidIndex(indexedColumn)) {
            return;
        }
        final IndexedElement<T, ?> indexedElement = this.getIndexedElement(indexedColumn);
        if (indexedColumn.getSubPropertyNameMatcher() == null) {
            matchingProperties.found(indexedElement.getPropertyMeta(), new Runnable(){

                @Override
                public void run() {
                    if (!indexedElement.hasProperty("{this}")) {
                        indexedElement.addProperty("{this}");
                    }
                }
            }, score);
            return;
        }
        PropertyFinder<?> eltPropertyFinder = indexedElement.getPropertyFinder();
        if (eltPropertyFinder == null) {
            return;
        }
        propertyFinderTransformer.apply(eltPropertyFinder).lookForProperties(indexedColumn.getSubPropertyNameMatcher(), new PropertyFinder.FoundProperty(){

            public void found(final PropertyMeta propertyMeta, final Runnable selectionCallback, PropertyMatchingScore score) {
                PropertyMeta<Object, Object> subProperty = propertyMeta.isSelf() ? indexedElement.getPropertyMeta() : new SubPropertyMeta(AbstractIndexPropertyFinder.this.classMeta.getReflectionService(), indexedElement.getPropertyMeta(), propertyMeta);
                matchingProperties.found(subProperty, new Runnable(){

                    @Override
                    public void run() {
                        selectionCallback.run();
                        indexedElement.addProperty(propertyMeta);
                    }
                }, score);
            }
        }, score, true, propertyFinderTransformer);
    }

    private void speculativeMatching(PropertyNameMatcher propertyNameMatcher, PropertyFinder.FoundProperty foundProperty, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer) {
        PropertyNameMatch speculativeMatch = propertyNameMatcher.speculativeMatch();
        if (speculativeMatch != null) {
            this.extrapolateIndex(speculativeMatch.getLeftOverMatcher(), foundProperty, score, propertyFinderTransformer);
        }
    }

    protected abstract boolean isValidIndex(IndexedColumn var1);

    protected abstract <E> IndexedElement<T, ?> getIndexedElement(IndexedColumn var1);

    protected abstract void extrapolateIndex(PropertyNameMatcher var1, PropertyFinder.FoundProperty var2, PropertyMatchingScore var3, PropertyFinder.PropertyFinderTransformer var4);

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.classMeta.getInstantiatorDefinitions();
    }

    @Override
    public Type getOwnerType() {
        return this.classMeta.getType();
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> owner) {
        for (IndexedElement<T, ?> ie : this.elements) {
            if (!ie.getPropertyMeta().equals(owner)) continue;
            return ie.getPropertyFinder();
        }
        throw new IllegalArgumentException("Unexpected owner " + owner);
    }
}

