/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ScoredGetter;
import org.simpleflatmapper.reflect.ScoredSetter;
import org.simpleflatmapper.reflect.meta.AbstractIndexPropertyFinder;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.TupleClassMeta;
import org.simpleflatmapper.util.TypeHelper;

public class TuplePropertyFinder<T>
extends AbstractIndexPropertyFinder<T> {
    public TuplePropertyFinder(TupleClassMeta<T> tupleClassMeta) {
        super(tupleClassMeta);
        for (int i = 0; i < tupleClassMeta.getTupleSize(); ++i) {
            this.elements.add(this.newIndexedElement(tupleClassMeta, i));
        }
    }

    private <E> IndexedElement<T, E> newIndexedElement(TupleClassMeta<T> tupleClassMeta, int i) {
        ConstructorPropertyMeta<T, E> prop = this.newConstructorPropertyMeta(tupleClassMeta, i);
        ClassMeta classMeta = tupleClassMeta.getReflectionService().getClassMeta(prop.getPropertyType());
        return new IndexedElement<T, E>(prop, classMeta);
    }

    private <E> ConstructorPropertyMeta<T, E> newConstructorPropertyMeta(TupleClassMeta<T> tupleClassMeta, int i) {
        Class tClass = TypeHelper.toClass((Type)tupleClassMeta.getType());
        InstantiatorDefinition instantiatorDefinition = this.getEligibleInstantiatorDefinitions().get(0);
        Parameter parameter = instantiatorDefinition.getParameters()[i];
        Getter getter = tupleClassMeta.getReflectionService().getObjectGetterFactory().getGetter(tClass, parameter.getName());
        return new ConstructorPropertyMeta(parameter.getName(), tupleClassMeta.getReflectionService(), parameter, tClass, ScoredGetter.of(getter, Integer.MAX_VALUE), ScoredSetter.nullSetter(), instantiatorDefinition);
    }

    @Override
    protected boolean isValidIndex(IndexedColumn indexedColumn) {
        return indexedColumn.getIndexValue() < this.elements.size();
    }

    @Override
    protected IndexedElement<T, ?> getIndexedElement(IndexedColumn indexedColumn) {
        return (IndexedElement)this.elements.get(indexedColumn.getIndexValue());
    }

    @Override
    protected IndexedColumn extrapolateIndex(PropertyNameMatcher propertyNameMatcher) {
        for (int i = 0; i < this.elements.size(); ++i) {
            PropertyFinder pf;
            PropertyMeta property;
            IndexedElement element = (IndexedElement)this.elements.get(i);
            if (element.getElementClassMeta() == null || (property = (pf = element.getPropertyFinder()).findProperty(propertyNameMatcher)) == null || element.hasProperty(property)) continue;
            return new IndexedColumn(i, propertyNameMatcher);
        }
        return null;
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(String name) {
        return null;
    }
}

