/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.List;
import java.util.Optional;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.OptionalClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;

public class OptionalPropertyFinder<T>
implements PropertyFinder<Optional<T>> {
    private final OptionalClassMeta<T> optionalClassMeta;
    private final PropertyFinder<T> propertyFinder;
    private int nbProp = 0;
    private final ClassMeta<T> innerMeta;

    public OptionalPropertyFinder(OptionalClassMeta<T> optionalClassMeta) {
        this.optionalClassMeta = optionalClassMeta;
        this.innerMeta = optionalClassMeta.getInnerMeta();
        this.propertyFinder = this.innerMeta != null ? this.innerMeta.newPropertyFinder() : null;
    }

    @Override
    public <E> PropertyMeta<Optional<T>, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
        if (!this.innerMeta.isLeaf()) {
            PropertyMeta property = this.propertyFinder.findProperty(propertyNameMatcher);
            if (property != null) {
                return this.getSubPropertyMeta(property);
            }
        } else if (this.nbProp == 0) {
            ++this.nbProp;
            return this.optionalClassMeta.getProperty();
        }
        return null;
    }

    private <I, E> PropertyMeta<Optional<T>, E> getSubPropertyMeta(PropertyMeta<I, ?> property) {
        return new SubPropertyMeta(this.optionalClassMeta.getReflectionService(), this.optionalClassMeta.getProperty(), property);
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.optionalClassMeta.getInstantiatorDefinitions();
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(String name) {
        return null;
    }
}

