/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.ScoredGetter;
import org.simpleflatmapper.reflect.ScoredSetter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.GetterHelper;
import org.simpleflatmapper.reflect.impl.ParamNameDeductor;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ClassVisitor;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.FieldAndMethodCallBack;
import org.simpleflatmapper.reflect.meta.ObjectPropertyFinder;
import org.simpleflatmapper.reflect.meta.ObjectPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.setter.SetterHelper;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.TypeHelper;

public final class ObjectClassMeta<T>
implements ClassMeta<T> {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final List<PropertyMeta<T, ?>> properties;
    private final List<ConstructorPropertyMeta<T, ?>> constructorProperties;
    private final List<InstantiatorDefinition> instantiatorDefinitions;
    private final ReflectionService reflectService;
    private final Type target;
    private final Map<String, String> fieldAliases;

    public ObjectClassMeta(Type target, ReflectionService reflectService) {
        this(target, null, reflectService);
    }

    public ObjectClassMeta(Type target, Member builderInstantiator, ReflectionService reflectService) {
        this.target = target;
        this.reflectService = reflectService;
        try {
            this.instantiatorDefinitions = reflectService.extractInstantiator(target, builderInstantiator);
            this.constructorProperties = this.listConstructorProperties(this.instantiatorDefinitions);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
        this.fieldAliases = Collections.unmodifiableMap(this.aliases(reflectService, TypeHelper.toClass((Type)target)));
        this.properties = Collections.unmodifiableList(this.listProperties(reflectService, target));
    }

    public ObjectClassMeta(Type target, List<InstantiatorDefinition> instantiatorDefinitions, List<ConstructorPropertyMeta<T, ?>> constructorProperties, List<PropertyMeta<T, ?>> properties, ReflectionService reflectService) {
        this.target = target;
        this.properties = properties;
        this.constructorProperties = constructorProperties;
        this.instantiatorDefinitions = instantiatorDefinitions;
        this.fieldAliases = Collections.unmodifiableMap(this.aliases(reflectService, TypeHelper.toClass((Type)target)));
        this.reflectService = reflectService;
    }

    private Map<String, String> aliases(final ReflectionService reflectService, Class<T> target) {
        final HashMap<String, String> map = new HashMap<String, String>();
        ClassVisitor.visit(target, new FieldAndMethodCallBack(){

            @Override
            public void method(Method method) {
                String alias = reflectService.getColumnName(method);
                if (alias != null) {
                    String name;
                    if (SetterHelper.isSetter(method)) {
                        name = SetterHelper.getPropertyNameFromMethodName(method.getName());
                    } else if (GetterHelper.isGetter(method)) {
                        name = GetterHelper.getPropertyNameFromMethodName(method.getName());
                    } else {
                        throw new IllegalArgumentException("Annotation on non accessor method " + method);
                    }
                    map.put(name, alias);
                }
            }

            @Override
            public void field(Field field) {
                String alias = reflectService.getColumnName(field);
                if (alias != null) {
                    map.put(field.getName(), alias);
                }
            }
        });
        return map;
    }

    private List<ConstructorPropertyMeta<T, ?>> listConstructorProperties(List<InstantiatorDefinition> instantiatorDefinitions) {
        if (instantiatorDefinitions == null) {
            return null;
        }
        ArrayList constructorProperties = new ArrayList();
        ParamNameDeductor paramNameDeductor = null;
        for (InstantiatorDefinition cd : instantiatorDefinitions) {
            for (Parameter param : cd.getParameters()) {
                String paramName = param.getName();
                if (paramName == null) {
                    if (paramNameDeductor == null) {
                        paramNameDeductor = new ParamNameDeductor(TypeHelper.toClass((Type)this.target));
                    }
                    paramName = paramNameDeductor.findParamName(cd, param);
                }
                constructorProperties.add(this.constructorMeta(param, paramName, cd));
            }
        }
        return constructorProperties;
    }

    private <P> ConstructorPropertyMeta<T, P> constructorMeta(Parameter param, String paramName, InstantiatorDefinition instantiatorDefinition) {
        Class tClass = TypeHelper.toClass((Type)this.target);
        return new ConstructorPropertyMeta(paramName, this.reflectService, param, tClass, instantiatorDefinition);
    }

    private List<PropertyMeta<T, ?>> listProperties(final ReflectionService reflectService, Type targetType) {
        Class target = TypeHelper.toClass((Type)targetType);
        final ArrayList properties = new ArrayList();
        final Map typeVariableTypeMap = TypeHelper.getTypesMap((Type)targetType);
        ClassVisitor.visit(target, new FieldAndMethodCallBack(){

            @Override
            public void method(Method method) {
                String name = method.getName();
                if (SetterHelper.isSetter(method)) {
                    String propertyName = SetterHelper.getPropertyNameFromMethodName(name);
                    Setter methodSetter = reflectService.getObjectSetterFactory().getMethodSetter(method);
                    this.register(propertyName, method.getGenericParameterTypes()[0], ScoredGetter.nullGetter(), ScoredSetter.ofMethod(method, methodSetter));
                } else if (GetterHelper.isGetter(method)) {
                    String propertyName = GetterHelper.getPropertyNameFromMethodName(name);
                    Getter methodGetter = reflectService.getObjectGetterFactory().getMethodGetter(method);
                    this.register(propertyName, method.getReturnType(), ScoredGetter.ofMethod(method, methodGetter), ScoredSetter.nullSetter());
                }
            }

            private <P> void register(String propertyName, Type type, ScoredGetter<T, P> getter, ScoredSetter<T, P> setter) {
                int indexOfProperty;
                Type mappedType;
                if (type instanceof TypeVariable && (mappedType = (Type)typeVariableTypeMap.get(type)) != null) {
                    type = mappedType;
                }
                if ((indexOfProperty = this.findProperty(ObjectClassMeta.this.constructorProperties, propertyName)) != -1) {
                    ConstructorPropertyMeta constructorPropertyMeta = (ConstructorPropertyMeta)ObjectClassMeta.this.constructorProperties.get(indexOfProperty);
                    if (getter != null && GetterHelper.isCompatible(constructorPropertyMeta.getPropertyType(), type)) {
                        constructorPropertyMeta = constructorPropertyMeta.getter(getter);
                        ObjectClassMeta.this.constructorProperties.set(indexOfProperty, constructorPropertyMeta);
                    }
                    if (setter != null && SetterHelper.isCompatible(constructorPropertyMeta.getPropertyType(), type)) {
                        constructorPropertyMeta = constructorPropertyMeta.setter(setter);
                        ObjectClassMeta.this.constructorProperties.set(indexOfProperty, constructorPropertyMeta);
                    }
                } else {
                    indexOfProperty = this.findProperty(properties, propertyName);
                    if (indexOfProperty == -1) {
                        properties.add(new ObjectPropertyMeta(propertyName, reflectService, type, getter, setter));
                    } else {
                        ObjectPropertyMeta meta = (ObjectPropertyMeta)properties.get(indexOfProperty);
                        ScoredGetter compatibleGetter = GetterHelper.isCompatible(meta.getPropertyType(), type) ? getter : ScoredGetter.nullGetter();
                        ScoredSetter compatibleSetter = SetterHelper.isCompatible(meta.getPropertyType(), type) ? setter : ScoredSetter.nullSetter();
                        properties.set(indexOfProperty, meta.getterSetter(compatibleGetter, compatibleSetter));
                    }
                }
            }

            @Override
            public void field(Field field) {
                String name = field.getName();
                if (!Modifier.isStatic(field.getModifiers())) {
                    ScoredGetter getter = ScoredGetter.ofField(field, reflectService.getObjectGetterFactory().getFieldGetter(field));
                    ScoredSetter setter = !Modifier.isFinal(field.getModifiers()) ? ScoredSetter.ofField(field, reflectService.getObjectSetterFactory().getFieldSetter(field)) : ScoredSetter.nullSetter();
                    this.register(name, field.getGenericType(), getter, setter);
                }
            }

            private int findProperty(List<? extends PropertyMeta<T, ?>> properties2, String name) {
                for (int i = 0; i < properties2.size(); ++i) {
                    PropertyMeta propertyMeta = properties2.get(i);
                    String propertyMetaName = propertyMeta.getName();
                    if (propertyMetaName == null || !propertyMetaName.equals(name)) continue;
                    return i;
                }
                return -1;
            }
        });
        return properties;
    }

    protected String getAlias(String propertyName) {
        String columnName = this.fieldAliases.get(propertyName);
        if (columnName == null) {
            columnName = propertyName;
        }
        return columnName;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return this.instantiatorDefinitions;
    }

    List<PropertyMeta<T, ?>> getProperties() {
        return this.properties;
    }

    List<ConstructorPropertyMeta<T, ?>> getConstructorProperties() {
        return this.constructorProperties;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return new ObjectPropertyFinder(this);
    }

    @Override
    public Type getType() {
        return this.target;
    }

    @Override
    public String[] generateHeaders() {
        ArrayList<String> strings = new ArrayList<String>();
        for (PropertyMeta propertyMeta : this.constructorProperties) {
            if (((ConstructorPropertyMeta)propertyMeta).getConstructorParameterSize() <= 1 && propertyMeta.getPropertyClassMeta() == this) continue;
            this.extractProperties(strings, propertyMeta);
        }
        for (PropertyMeta propertyMeta : this.properties) {
            this.extractProperties(strings, propertyMeta);
        }
        return strings.toArray(EMPTY_STRING_ARRAY);
    }

    private void extractProperties(List<String> properties, PropertyMeta<T, ?> cpm) {
        String prefix = cpm.getName();
        ClassMeta<?> classMeta = cpm.getPropertyClassMeta();
        if (classMeta != null) {
            for (String prop : classMeta.generateHeaders()) {
                String name;
                String string = name = prop.length() == 0 ? prefix : prefix + "_" + prop;
                if (properties.contains(name)) continue;
                properties.add(this.formatName(name));
            }
        } else if (!properties.contains(prefix)) {
            properties.add(this.formatName(prefix));
        }
    }

    private String formatName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean lastWasUpperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!lastWasUpperCase) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            lastWasUpperCase = false;
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public int getNumberOfProperties() {
        return this.constructorProperties.size() + this.properties.size();
    }

    public PropertyMeta<T, ?> getFirstProperty() {
        if (!this.constructorProperties.isEmpty()) {
            return this.constructorProperties.get(0);
        }
        if (!this.properties.isEmpty()) {
            return this.properties.get(0);
        }
        return null;
    }
}

