/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.ScoredGetter;
import org.simpleflatmapper.reflect.ScoredSetter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.GetterHelper;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.TypeHelper;

public class FastTupleClassMeta<T>
implements ClassMeta<T> {
    private final ClassMeta<T> delegate;
    private final String[] headers;
    private final List<InstantiatorDefinition> instantiatorDefinitions;

    public FastTupleClassMeta(Type target, ReflectionService reflectionService) {
        try {
            Class clazz = TypeHelper.toClass((Type)target);
            this.instantiatorDefinitions = new ArrayList<InstantiatorDefinition>();
            this.instantiatorDefinitions.add(new ExecutableInstantiatorDefinition(clazz.getConstructor(new Class[0]), new Parameter[0]));
            ArrayList<PropertyMeta<T, ?>> properties = this.getPropertyMetas(clazz, reflectionService);
            this.delegate = new ObjectClassMeta(target, this.instantiatorDefinitions, new ArrayList(), properties, reflectionService);
            this.headers = this.getHeaders(clazz, properties);
        }
        catch (NoSuchMethodException e) {
            ErrorHelper.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
    }

    private String[] getHeaders(Class<?> clazz, List<PropertyMeta<T, ?>> properties) {
        try {
            clazz.getDeclaredField("unsafe");
            return null;
        }
        catch (NoSuchFieldException e) {
            Field[] declaredFields = clazz.getDeclaredFields();
            String[] headers = new String[properties.size()];
            for (int i = 0; i < declaredFields.length; ++i) {
                String name = declaredFields[i].getName();
                if (!this.isPresent(properties, name)) continue;
                headers[i] = name;
            }
            return headers;
        }
    }

    private boolean isPresent(List<PropertyMeta<T, ?>> properties, String name) {
        for (PropertyMeta<T, ?> pm : properties) {
            if (!pm.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<PropertyMeta<T, ?>> getPropertyMetas(Class<T> clazz, ReflectionService reflectionService) throws NoSuchMethodException {
        ArrayList propertyMetas = new ArrayList();
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getParameterTypes().length != 0 || !GetterHelper.isPublicMember(m.getModifiers())) continue;
            String field = m.getName();
            Method setter = clazz.getDeclaredMethod(field, m.getReturnType());
            ObjectPropertyMeta propertyMeta = this.newPropertyMethod(field, m, setter, reflectionService);
            propertyMetas.add(propertyMeta);
        }
        return propertyMetas;
    }

    private <P> ObjectPropertyMeta<T, P> newPropertyMethod(String field, Method getter, Method setter, ReflectionService reflectionService) {
        Getter methodGetter = reflectionService.getObjectGetterFactory().getMethodGetter(getter);
        Setter methodSetter = reflectionService.getObjectSetterFactory().getMethodSetter(setter);
        return new ObjectPropertyMeta(field, reflectionService, getter.getGenericReturnType(), ScoredGetter.of(methodGetter, 1), ScoredSetter.of(methodSetter, 1));
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.delegate.getReflectionService();
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return this.delegate.newPropertyFinder();
    }

    @Override
    public Type getType() {
        return this.delegate.getType();
    }

    @Override
    public String[] generateHeaders() {
        if (this.headers == null) {
            throw new UnsupportedOperationException("Cannot generate headers on directMemory tuple");
        }
        return this.headers;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return this.instantiatorDefinitions;
    }
}

