/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.poi.impl;

import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.util.Enumerable;

public class SheetEnumerable<T>
implements Enumerable<T> {
    private final SourceMapper<Row, T> mapper;
    private final Sheet sheet;
    private final MappingContext<? super Row> mappingContext;
    private int rowNum;
    private int lastRowNum;
    private T currentValue;

    public SheetEnumerable(SourceMapper<Row, T> mapper, int startRow, Sheet sheet, MappingContext<? super Row> mappingContext) {
        this.mapper = mapper;
        this.rowNum = startRow;
        this.lastRowNum = sheet.getLastRowNum();
        this.sheet = sheet;
        this.mappingContext = mappingContext;
    }

    public boolean next() {
        this.currentValue = null;
        while (this.rowNum <= this.lastRowNum) {
            Row row = this.sheet.getRow(this.rowNum);
            ++this.rowNum;
            if (row == null) continue;
            this.currentValue = this.mapper.map((Object)row, this.mappingContext);
            return true;
        }
        return false;
    }

    public T currentValue() {
        return this.currentValue;
    }
}

