/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.poi.impl;

import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.util.Enumerable;

public class SheetEnumerable<T>
implements Enumerable<T> {
    private final SourceMapper<Row, T> mapper;
    private final Sheet sheet;
    private final MappingContext<? super Row> mappingContext;
    private int rowNum;

    public SheetEnumerable(SourceMapper<Row, T> mapper, int startRow, Sheet sheet, MappingContext<? super Row> mappingContext) {
        this.mapper = mapper;
        this.rowNum = startRow;
        this.sheet = sheet;
        this.mappingContext = mappingContext;
    }

    public boolean next() {
        int n = this.rowNum + 1;
        if (this.rowNum <= this.sheet.getLastRowNum()) {
            this.rowNum = n;
            return true;
        }
        return false;
    }

    public T currentValue() {
        Row row = this.sheet.getRow(this.rowNum);
        return (T)this.mapper.map((Object)row, this.mappingContext);
    }
}

