/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.poi.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.CsvColumnKeyMapperKeyComparator;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.mapper.MapperCache;
import org.simpleflatmapper.map.mapper.MapperKey;
import org.simpleflatmapper.map.mapper.MapperKeyComparator;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.poi.SheetMapper;
import org.simpleflatmapper.poi.SheetMapperBuilder;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Enumerable;

public class DynamicSheetMapper<T>
implements SheetMapper<T> {
    private final int startRow = 0;
    private final MapperCache<CsvColumnKey, SheetMapper<T>> mapperCache = new MapperCache((MapperKeyComparator)CsvColumnKeyMapperKeyComparator.INSTANCE);
    private final ClassMeta<T> classMeta;
    private final MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig;
    private final GetterFactory<Row, CsvColumnKey> getterFactory;

    public DynamicSheetMapper(ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, GetterFactory<Row, CsvColumnKey> getterFactory) {
        this.classMeta = classMeta;
        this.mapperConfig = mapperConfig;
        this.getterFactory = getterFactory;
    }

    @Override
    public Iterator<T> iterator(Sheet sheet) {
        return this.iterator(0, sheet);
    }

    @Override
    public Iterator<T> iterator(int startRow, Sheet sheet) {
        return this.getPoiMapper(startRow, sheet).iterator(startRow + 1, sheet);
    }

    @Override
    public Enumerable<T> enumerate(Sheet sheet) {
        return this.getPoiMapper(0, sheet).enumerate(sheet);
    }

    @Override
    public Enumerable<T> enumerate(int startRow, Sheet sheet) {
        return this.getPoiMapper(startRow, sheet).enumerate(startRow, sheet);
    }

    @Override
    public <RH extends CheckedConsumer<? super T>> RH forEach(Sheet sheet, RH consumer) {
        return this.forEach(0, sheet, consumer);
    }

    @Override
    public <RH extends CheckedConsumer<? super T>> RH forEach(int startRow, Sheet sheet, RH consumer) {
        return this.getPoiMapper(startRow, sheet).forEach(startRow + 1, sheet, consumer);
    }

    @Override
    public Stream<T> stream(Sheet sheet) {
        return this.stream(0, sheet);
    }

    @Override
    public Stream<T> stream(int startRow, Sheet sheet) {
        return this.getPoiMapper(startRow, sheet).stream(startRow + 1, sheet);
    }

    private SheetMapper<T> getPoiMapper(int startRow, Sheet sheet) {
        Row row = sheet.getRow(startRow);
        ArrayList<CsvColumnKey> keys = new ArrayList<CsvColumnKey>(row.getLastCellNum() - row.getFirstCellNum());
        for (short i = row.getFirstCellNum(); i <= row.getLastCellNum(); i = (short)(i + 1)) {
            Cell cell = row.getCell((int)i);
            if (cell == null || cell.getCellType() == 3) continue;
            keys.add(new CsvColumnKey(cell.getStringCellValue(), (int)i));
        }
        return this.getPoiMapper((MapperKey<CsvColumnKey>)new MapperKey((FieldKey[])keys.toArray(new CsvColumnKey[0])));
    }

    private SheetMapper<T> getPoiMapper(MapperKey<CsvColumnKey> key) {
        SheetMapper mapper = (SheetMapper)this.mapperCache.get(key);
        if (mapper == null) {
            SheetMapperBuilder<T> builder = new SheetMapperBuilder<T>(this.classMeta, this.mapperConfig, this.getterFactory);
            for (CsvColumnKey k : (CsvColumnKey[])key.getColumns()) {
                builder.addMapping((FieldKey)k, FieldMapperColumnDefinition.identity());
            }
            mapper = (SheetMapper)builder.mapper();
            this.mapperCache.add(key, (Object)mapper);
        }
        return mapper;
    }
}

