/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.poi.impl;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.util.EnumHelper;

public class PoiEnumGetter<E extends Enum<E>>
implements Getter<Row, E> {
    private final int index;
    private final Class<E> enumClass;
    private final E[] values;

    public PoiEnumGetter(int index, Class<E> enumClass) {
        this.index = index;
        this.enumClass = enumClass;
        this.values = EnumHelper.getValues(enumClass);
    }

    public E get(Row target) throws Exception {
        Cell cell = target.getCell(this.index);
        if (cell != null) {
            switch (cell.getCellType()) {
                case 3: {
                    return null;
                }
                case 1: {
                    return Enum.valueOf(this.enumClass, cell.getStringCellValue());
                }
                case 0: {
                    return this.values[(int)cell.getNumericCellValue()];
                }
            }
            throw new UnsupportedOperationException("Cannot convert cell to enum");
        }
        return null;
    }
}

