/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.poi.impl;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.mapper.JoinMapperEnumarable;
import org.simpleflatmapper.poi.RowMapper;
import org.simpleflatmapper.poi.impl.RowEnumarable;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Enumarable;
import org.simpleflatmapper.util.EnumarableIterator;
import org.simpleflatmapper.util.EnumarableSpliterator;

public class JoinSheetMapper<T>
implements RowMapper<T> {
    private final Mapper<Row, T> mapper;
    private final int startRow = 0;
    private final ConsumerErrorHandler consumerErrorHandler;
    private final MappingContextFactory<? super Row> mappingContextFactory;

    public JoinSheetMapper(Mapper<Row, T> mapper, ConsumerErrorHandler consumerErrorHandler, MappingContextFactory<? super Row> mappingContextFactory) {
        this.mapper = mapper;
        this.consumerErrorHandler = consumerErrorHandler;
        this.mappingContextFactory = mappingContextFactory;
    }

    @Override
    public Iterator<T> iterator(Sheet sheet) {
        return this.iterator(0, sheet);
    }

    @Override
    public Iterator<T> iterator(int startRow, Sheet sheet) {
        return new EnumarableIterator(this.enumerable(startRow, sheet, this.newMappingContext()));
    }

    private Enumarable<T> enumerable(int startRow, Sheet sheet, MappingContext<? super Row> mappingContext) {
        return new JoinMapperEnumarable(this.mapper, mappingContext, (Enumarable)new RowEnumarable(startRow, sheet));
    }

    @Override
    public <RH extends CheckedConsumer<T>> RH forEach(Sheet sheet, RH consumer) {
        return this.forEach(0, sheet, consumer);
    }

    @Override
    public <RH extends CheckedConsumer<T>> RH forEach(int startRow, Sheet sheet, RH consumer) {
        MappingContext<Row> mappingContext = this.newMappingContext();
        Enumarable<T> enumarable = this.enumerable(startRow, sheet, mappingContext);
        while (enumarable.next()) {
            try {
                consumer.accept(enumarable.currentValue());
            }
            catch (Exception e) {
                this.consumerErrorHandler.handlerError((Throwable)e, enumarable.currentValue());
            }
        }
        return consumer;
    }

    @Override
    public Stream<T> stream(Sheet sheet) {
        return this.stream(0, sheet);
    }

    @Override
    public Stream<T> stream(int startRow, Sheet sheet) {
        return StreamSupport.stream(new EnumarableSpliterator(this.enumerable(startRow, sheet, this.newMappingContext())), false);
    }

    public T map(Row source) throws MappingException {
        return (T)this.mapper.map((Object)source);
    }

    public T map(Row source, MappingContext<? super Row> context) throws MappingException {
        return (T)this.mapper.map((Object)source, context);
    }

    public void mapTo(Row source, T target, MappingContext<? super Row> context) throws Exception {
        this.mapper.mapTo((Object)source, target, context);
    }

    private MappingContext<? super Row> newMappingContext() {
        return this.mappingContextFactory.newContext();
    }
}

