/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.poi.impl;

import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.poi.impl.StaticSheetMapper;

public class SheetSpliterator<T>
implements Spliterator<T> {
    private final StaticSheetMapper<T> mapper;
    private final Sheet sheet;
    private final MappingContext<? super Row> mappingContext;
    private int rowNum;

    public SheetSpliterator(StaticSheetMapper<T> mapper, int startRow, Sheet sheet, MappingContext<? super Row> mappingContext) {
        this.mapper = mapper;
        this.rowNum = startRow;
        this.sheet = sheet;
        this.mappingContext = mappingContext;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        Sheet lSheet = this.sheet;
        StaticSheetMapper<T> lMapper = this.mapper;
        MappingContext<? super Row> lMappingContext = this.mappingContext;
        for (int i = this.rowNum; i <= lSheet.getLastRowNum(); ++i) {
            action.accept(lMapper.map(lSheet.getRow(i), lMappingContext));
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Sheet lSheet = this.sheet;
        if (this.rowNum <= lSheet.getLastRowNum()) {
            action.accept(this.mapper.map(lSheet.getRow(this.rowNum), this.mappingContext));
            ++this.rowNum;
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.sheet.getLastRowNum();
    }

    @Override
    public int characteristics() {
        return 272;
    }
}

