/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.poi.impl;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.sfm.map.Mapper;
import org.sfm.map.MappingContext;
import org.sfm.map.MappingException;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.map.context.MappingContextFactory;
import org.sfm.poi.RowMapper;
import org.sfm.poi.impl.SheetIterator;
import org.sfm.poi.impl.SheetSpliterator;
import org.sfm.utils.RowHandler;

public class StaticSheetMapper<T>
implements RowMapper<T> {
    private final Mapper<Row, T> mapper;
    private final int startRow = 0;
    private final RowHandlerErrorHandler rowHandlerErrorHandler;
    private final MappingContextFactory<Row> mappingContextFactory;

    public StaticSheetMapper(Mapper<Row, T> mapper, RowHandlerErrorHandler rowHandlerErrorHandler, MappingContextFactory<Row> mappingContextFactory) {
        this.mapper = mapper;
        this.rowHandlerErrorHandler = rowHandlerErrorHandler;
        this.mappingContextFactory = mappingContextFactory;
    }

    @Override
    public Iterator<T> iterator(Sheet sheet) {
        return this.iterator(0, sheet);
    }

    @Override
    public Iterator<T> iterator(int startRow, Sheet sheet) {
        return new SheetIterator(this, startRow, sheet, this.newMappingContext());
    }

    @Override
    public <RH extends RowHandler<T>> RH forEach(Sheet sheet, RH rowHandler) {
        return this.forEach(0, sheet, rowHandler);
    }

    @Override
    public <RH extends RowHandler<T>> RH forEach(int startRow, Sheet sheet, RH rowHandler) {
        MappingContext<Row> mappingContext = this.newMappingContext();
        Mapper<Row, T> lMapper = this.mapper;
        for (int rowNum = startRow; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            Object object = lMapper.map((Object)sheet.getRow(rowNum), mappingContext);
            try {
                rowHandler.handle(object);
                continue;
            }
            catch (Exception e) {
                this.rowHandlerErrorHandler.handlerError((Throwable)e, object);
            }
        }
        return rowHandler;
    }

    @Override
    public Stream<T> stream(Sheet sheet) {
        return this.stream(0, sheet);
    }

    @Override
    public Stream<T> stream(int startRow, Sheet sheet) {
        return StreamSupport.stream(new SheetSpliterator(this, startRow, sheet, this.newMappingContext()), false);
    }

    public T map(Row source) throws MappingException {
        return (T)this.mapper.map((Object)source);
    }

    public T map(Row source, MappingContext<? super Row> context) throws MappingException {
        return (T)this.mapper.map((Object)source, context);
    }

    public void mapTo(Row source, T target, MappingContext<? super Row> context) throws Exception {
        this.mapper.mapTo((Object)source, target, context);
    }

    private MappingContext<Row> newMappingContext() {
        return this.mappingContextFactory.newContext();
    }
}

