/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Type;
import org.sfm.reflect.Getter;
import org.sfm.reflect.GetterOnGetter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.PropertyMeta;

public class SubPropertyMeta<O, I, P>
extends PropertyMeta<O, P> {
    private final PropertyMeta<O, I> ownerProperty;
    private final PropertyMeta<I, P> subProperty;

    public SubPropertyMeta(ReflectionService reflectService, PropertyMeta<O, I> property, PropertyMeta<I, P> subProperty) {
        super(property.getName(), reflectService);
        this.ownerProperty = property;
        this.subProperty = subProperty;
    }

    @Override
    protected Setter<O, P> newSetter() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Getter<O, P> newGetter() {
        return new GetterOnGetter<O, I, P>(this.ownerProperty.getGetter(), this.subProperty.getGetter());
    }

    @Override
    protected ClassMeta<P> newPropertyClassMeta() {
        return this.subProperty.getPropertyClassMeta();
    }

    @Override
    public Type getPropertyType() {
        return this.subProperty.getPropertyType();
    }

    public PropertyMeta<O, I> getOwnerProperty() {
        return this.ownerProperty;
    }

    public PropertyMeta<I, P> getSubProperty() {
        return this.subProperty;
    }

    @Override
    public boolean isSubProperty() {
        return true;
    }

    @Override
    public String getPath() {
        return this.getOwnerProperty().getPath() + "." + this.subProperty.getPath();
    }

    public String toString() {
        return "SubPropertyMeta{ownerProperty=" + this.ownerProperty + ", subProperty=" + this.subProperty + '}';
    }
}

