/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.sfm.reflect.Getter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.impl.FieldGetter;
import org.sfm.reflect.impl.FieldSetter;
import org.sfm.reflect.meta.PropertyMeta;

public class FieldPropertyMeta<T, P>
extends PropertyMeta<T, P> {
    private final Field field;
    private final Type type;

    public FieldPropertyMeta(String name, ReflectionService reflectService, Field field, Type type) {
        super(name, reflectService);
        this.field = field;
        this.type = type;
    }

    @Override
    protected Setter<T, P> newSetter() {
        this.field.setAccessible(true);
        return new FieldSetter(this.field);
    }

    @Override
    protected Getter<T, P> newGetter() {
        this.field.setAccessible(true);
        return new FieldGetter(this.field);
    }

    @Override
    public Type getPropertyType() {
        return this.type;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    public String toString() {
        return "FieldPropertyMeta{field=" + this.field + ", type=" + this.type + '}';
    }
}

