/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Type;
import org.sfm.reflect.Getter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.meta.ArrayClassMeta;
import org.sfm.reflect.meta.PropertyMeta;

public class ArrayElementPropertyMeta<T, E>
extends PropertyMeta<T, E> {
    private final int index;
    private final ArrayClassMeta<T, E> arrayMetaData;

    public ArrayElementPropertyMeta(String name, ReflectionService reflectService, int index, ArrayClassMeta<T, E> arrayMetaData) {
        super(name, reflectService);
        if (index < 0) {
            throw new IllegalArgumentException("Invalid array index " + index);
        }
        this.index = index;
        this.arrayMetaData = arrayMetaData;
    }

    @Override
    protected Setter<T, E> newSetter() {
        return new IndexArraySetter(this.index);
    }

    @Override
    protected Getter<T, E> newGetter() {
        return new IndexArrayGetter(this.index);
    }

    @Override
    public Type getPropertyType() {
        return this.arrayMetaData.getElementTarget();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getPath() {
        return this.index + "." + this.getName();
    }

    public String toString() {
        return "ArrayElementPropertyMeta{index=" + this.index + '}';
    }

    private static class IndexArrayGetter<E>
    implements Getter<E[], E> {
        private final int index;

        private IndexArrayGetter(int index) {
            this.index = index;
        }

        @Override
        public E get(E[] target) throws Exception {
            return target[this.index];
        }
    }

    private static class IndexArraySetter<E>
    implements Setter<E[], E> {
        private final int index;

        private IndexArraySetter(int index) {
            this.index = index;
        }

        @Override
        public void set(E[] target, E value) throws Exception {
            target[this.index] = value;
        }
    }
}

