/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.asm;

import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Set;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;

public class InstantiatorKey {
    private final Member constructor;
    private final String[] injectedParams;
    private final Class<?> source;

    public InstantiatorKey(Member constructor, String[] injectedParams, Class<?> source) {
        this.constructor = constructor;
        this.injectedParams = injectedParams;
        this.source = source;
    }

    public InstantiatorKey(Class<?> target, Class<?> source) throws NoSuchMethodException, SecurityException {
        this(target.getConstructor(new Class[0]), null, source);
    }

    public InstantiatorKey(InstantiatorDefinition instantiatorDefinition, Set<Parameter> injections, Class<?> source) {
        this(instantiatorDefinition.getExecutable(), InstantiatorKey.toParamNameS(injections), source);
    }

    private static String[] toParamNameS(Set<Parameter> keySet) {
        Object[] names = new String[keySet.size()];
        int i = 0;
        for (Parameter param : keySet) {
            names[i++] = param.getName();
        }
        Arrays.sort(names);
        return names;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        result = 31 * result + Arrays.hashCode(this.injectedParams);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstantiatorKey other = (InstantiatorKey)obj;
        if (this.constructor == null ? other.constructor != null : !this.constructor.equals(other.constructor)) {
            return false;
        }
        if (!Arrays.equals(this.injectedParams, other.injectedParams)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public Member getConstructor() {
        return this.constructor;
    }

    public String[] getInjectedParams() {
        return this.injectedParams;
    }

    public Class<?> getSource() {
        return this.source;
    }
}

