/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.asm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.sfm.reflect.TypeHelper;

public class AsmUtils {
    public static final String ASM_DUMP_TARGET_DIR = "asm.dump.target.dir";
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    static final Map<Class<?>, Class<?>> wrappers = new HashMap();
    static final Map<Class<?>, String> primitivesType;
    static final Map<String, String> stringToPrimitivesType;
    static final Map<Class<?>, Integer> loadOps;
    static final Map<Class<?>, Integer> returnOps;
    static final Map<Class<?>, Integer> defaultValue;
    static final Set<Class<?>> primitivesClassAndWrapper;
    static File targetDir;

    public static String toType(Type target) {
        return AsmUtils.toType(TypeHelper.toClass(target));
    }

    public static String toType(Class<?> target) {
        if (target.isPrimitive()) {
            return primitivesType.get(target);
        }
        return AsmUtils.toType(AsmUtils.getPublicOrInterfaceClass(target).getName());
    }

    public static String toType(String name) {
        return name.replace('.', '/');
    }

    public static boolean isStillGeneric(Class<?> clazz) {
        TypeVariable<Class<?>>[] typeParameters = (clazz = AsmUtils.getPublicOrInterfaceClass(clazz)).getTypeParameters();
        return typeParameters != null && typeParameters.length > 0;
    }

    public static byte[] writeClassToFile(String className, byte[] bytes) throws IOException {
        return AsmUtils.writeClassToFileInDir(className, bytes, targetDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] writeClassToFileInDir(String className, byte[] bytes, File targetDir) throws IOException {
        if (targetDir != null) {
            int lastIndex = className.lastIndexOf(46);
            String filename = className.substring(lastIndex + 1) + ".class";
            String directory = className.substring(0, lastIndex).replace('.', '/');
            File packageDir = new File(targetDir, directory);
            packageDir.mkdirs();
            try (FileOutputStream fos = new FileOutputStream(new File(packageDir, filename));){
                fos.write(bytes);
            }
        }
        return bytes;
    }

    public static String toTypeWithParam(Class<?> class1) {
        StringBuilder sb = new StringBuilder();
        class1 = AsmUtils.getPublicOrInterfaceClass(class1);
        sb.append(AsmUtils.toType(class1));
        TypeVariable<Class<?>>[] typeParameters = class1.getTypeParameters();
        if (typeParameters != null && typeParameters.length > 0) {
            sb.append("<");
            for (TypeVariable<Class<?>> t : typeParameters) {
                String typeName = t.getName();
                sb.append(AsmUtils.toTypeParam(typeName));
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public static String toTypeParam(String typeName) {
        if (typeName.startsWith("[")) {
            return typeName;
        }
        return "L" + AsmUtils.toType(typeName) + ";";
    }

    public static Type toGenericType(String sig, List<String> genericTypeNames, Type target) throws ClassNotFoundException {
        int indexOf;
        if (sig.length() == 1) {
            switch (sig.charAt(0)) {
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
            }
        }
        if (sig.startsWith("L")) {
            if ((sig = sig.substring(1)).endsWith(";")) {
                sig = sig.substring(0, sig.length() - 1);
            }
        } else if (sig.startsWith("T")) {
            String templateType = sig.substring(1, sig.length() - (sig.endsWith(";") ? 1 : 0));
            int indexOfParam = genericTypeNames.indexOf(templateType);
            if (target instanceof ParameterizedType) {
                return ((ParameterizedType)target).getActualTypeArguments()[indexOfParam];
            }
            throw new IllegalArgumentException("Cannot resolve generic type " + sig + " from non ParameterizedType " + target);
        }
        if ((indexOf = sig.indexOf(60)) == -1) {
            return Class.forName(sig.replace('/', '.'));
        }
        Class<?> rawType = Class.forName(sig.substring(0, indexOf).replace('/', '.'));
        Type[] types = AsmUtils.parseTypes(sig.substring(indexOf + 1, sig.length() - 1), genericTypeNames, target);
        return new ParameterizedTypeImpl(rawType, types);
    }

    public static Class<?> getPublicOrInterfaceClass(Class<?> clazz) {
        if (!Modifier.isPublic(clazz.getModifiers()) && !Modifier.isStatic(clazz.getModifiers())) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                return interfaces[0];
            }
            return AsmUtils.getPublicOrInterfaceClass(clazz.getSuperclass());
        }
        return clazz;
    }

    public static void invoke(MethodVisitor mv, Class<?> target, String method, String sig) {
        Class<?> publicClass = AsmUtils.getPublicOrInterfaceClass(target);
        boolean isInterface = publicClass.isInterface();
        mv.visitMethodInsn(isInterface ? 185 : 182, AsmUtils.toType(publicClass), method, sig, isInterface);
    }

    public static String toDeclaredLType(String sourceType) {
        if (sourceType.startsWith("[L") || sourceType.startsWith("L")) {
            return sourceType;
        }
        return "L" + sourceType + ";";
    }

    public static Class<?> toWrapperClass(Type type) {
        Class clazz = TypeHelper.toClass(type);
        if (clazz.isPrimitive()) {
            return wrappers.get(clazz);
        }
        return clazz;
    }

    public static String toWrapperType(Type type) {
        return AsmUtils.toType(AsmUtils.toWrapperClass(type));
    }

    public static List<String> extractGenericTypeNames(String sig) {
        ArrayList<String> types = new ArrayList<String>();
        boolean nameDetected = false;
        int currentStart = -1;
        block4: for (int i = 0; i < sig.length(); ++i) {
            char c = sig.charAt(i);
            switch (c) {
                case ';': 
                case '<': {
                    if (nameDetected) continue block4;
                    nameDetected = true;
                    currentStart = i + 1;
                    continue block4;
                }
                case ':': {
                    types.add(sig.substring(currentStart, i));
                    nameDetected = false;
                }
            }
        }
        return types;
    }

    private static Type[] parseTypes(String sig, List<String> genericTypeNames, Type target) throws ClassNotFoundException {
        ArrayList<Type> types = new ArrayList<Type>();
        int genericLevel = 0;
        int currentStart = 0;
        block5: for (int i = 0; i < sig.length(); ++i) {
            char c = sig.charAt(i);
            switch (c) {
                case '<': {
                    ++genericLevel;
                    continue block5;
                }
                case '>': {
                    --genericLevel;
                    continue block5;
                }
                case ';': {
                    if (genericLevel != 0) continue block5;
                    types.add(AsmUtils.toGenericType(sig.substring(currentStart, i), genericTypeNames, target));
                    currentStart = i + 1;
                }
            }
        }
        return types.toArray(EMPTY_TYPE_ARRAY);
    }

    public static List<String> extractTypeNames(String sig) {
        final ArrayList<String> types = new ArrayList<String>();
        SignatureReader reader = new SignatureReader(sig);
        reader.accept(new SignatureVisitor(327680){

            public void visitFormalTypeParameter(String name) {
                System.out.println(name);
            }

            public SignatureVisitor visitClassBound() {
                return super.visitInterfaceBound();
            }

            public SignatureVisitor visitInterfaceBound() {
                return super.visitInterfaceBound();
            }

            public SignatureVisitor visitParameterType() {
                return new AppendType();
            }

            public SignatureVisitor visitReturnType() {
                return new AppendType();
            }

            public SignatureVisitor visitExceptionType() {
                return new AppendType();
            }

            class AppendType
            extends SignatureVisitor {
                StringBuilder sb;
                int l;

                public AppendType() {
                    super(327680);
                    this.sb = new StringBuilder();
                    this.l = 0;
                }

                public void visitBaseType(char descriptor) {
                    if (descriptor != 'V') {
                        this.sb.append(descriptor);
                        this.visitEnd();
                    }
                }

                public void visitTypeVariable(String name) {
                    this.sb.append("T");
                    this.sb.append(name);
                    this.visitEnd();
                }

                public SignatureVisitor visitArrayType() {
                    this.sb.append("[");
                    return this;
                }

                public void visitClassType(String name) {
                    this.sb.append("L");
                    this.sb.append(name);
                    this.visitEnd();
                }

                public void visitInnerClassType(String name) {
                    this.visitClassType(name);
                }

                public void visitTypeArgument() {
                    System.out.println("visitTypeArgument");
                }

                public SignatureVisitor visitTypeArgument(char wildcard) {
                    ++this.l;
                    if (this.sb.length() == 0) {
                        String t = (String)types.remove(types.size() - 1);
                        if (t.endsWith(";")) {
                            t = t.substring(0, t.length() - 1);
                        }
                        this.sb.append(t);
                        this.sb.append("<");
                    }
                    if (wildcard != '=') {
                        this.sb.append(wildcard);
                    }
                    return this;
                }

                public void visitEnd() {
                    if (this.l == 0) {
                        this.flush();
                    } else {
                        this.sb.append(";>");
                        --this.l;
                    }
                }

                private void flush() {
                    if (this.sb.length() > 0) {
                        if (this.sb.charAt(0) == 'L' || this.sb.charAt(0) == 'T') {
                            this.sb.append(";");
                        }
                        types.add(this.sb.toString());
                        this.sb = new StringBuilder();
                    }
                }
            }
        });
        return types;
    }

    public static String toDeclaredLType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return primitivesType.get(clazz);
        }
        return AsmUtils.toDeclaredLType(AsmUtils.toType(clazz));
    }

    public static String toSignature(Method exec) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Class<?> clazz : exec.getParameterTypes()) {
            sb.append(AsmUtils.toDeclaredLType(clazz));
        }
        sb.append(")");
        sb.append(AsmUtils.toDeclaredLType(exec.getReturnType()));
        return sb.toString();
    }

    public static void addIndex(MethodVisitor mv, int i) {
        switch (i) {
            case 0: {
                mv.visitInsn(3);
                return;
            }
            case 1: {
                mv.visitInsn(4);
                return;
            }
            case 2: {
                mv.visitInsn(5);
                return;
            }
            case 3: {
                mv.visitInsn(6);
                return;
            }
            case 4: {
                mv.visitInsn(7);
                return;
            }
            case 5: {
                mv.visitInsn(8);
                return;
            }
        }
        if (i <= 127) {
            mv.visitIntInsn(16, i);
        } else if (i <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, i);
        } else {
            mv.visitLdcInsn((Object)i);
        }
    }

    static {
        wrappers.put(Boolean.TYPE, Boolean.class);
        wrappers.put(Byte.TYPE, Byte.class);
        wrappers.put(Character.TYPE, Character.class);
        wrappers.put(Double.TYPE, Double.class);
        wrappers.put(Float.TYPE, Float.class);
        wrappers.put(Integer.TYPE, Integer.class);
        wrappers.put(Long.TYPE, Long.class);
        wrappers.put(Short.TYPE, Short.class);
        wrappers.put(Void.TYPE, Void.class);
        primitivesType = new HashMap();
        primitivesType.put(Boolean.TYPE, "Z");
        primitivesType.put(Byte.TYPE, "B");
        primitivesType.put(Character.TYPE, "C");
        primitivesType.put(Double.TYPE, "D");
        primitivesType.put(Float.TYPE, "F");
        primitivesType.put(Integer.TYPE, "I");
        primitivesType.put(Long.TYPE, "J");
        primitivesType.put(Short.TYPE, "S");
        primitivesType.put(Void.TYPE, "V");
        stringToPrimitivesType = new HashMap<String, String>();
        stringToPrimitivesType.put("Boolean", "Z");
        stringToPrimitivesType.put("Byte", "B");
        stringToPrimitivesType.put("Character", "C");
        stringToPrimitivesType.put("Double", "D");
        stringToPrimitivesType.put("Float", "F");
        stringToPrimitivesType.put("Int", "I");
        stringToPrimitivesType.put("Long", "J");
        stringToPrimitivesType.put("Short", "S");
        loadOps = new HashMap();
        loadOps.put(Boolean.TYPE, 21);
        loadOps.put(Byte.TYPE, 21);
        loadOps.put(Character.TYPE, 21);
        loadOps.put(Double.TYPE, 24);
        loadOps.put(Float.TYPE, 23);
        loadOps.put(Integer.TYPE, 21);
        loadOps.put(Long.TYPE, 22);
        loadOps.put(Short.TYPE, 21);
        returnOps = new HashMap();
        returnOps.put(Boolean.TYPE, 172);
        returnOps.put(Byte.TYPE, 172);
        returnOps.put(Character.TYPE, 172);
        returnOps.put(Double.TYPE, 175);
        returnOps.put(Float.TYPE, 174);
        returnOps.put(Integer.TYPE, 172);
        returnOps.put(Long.TYPE, 173);
        returnOps.put(Short.TYPE, 172);
        defaultValue = new HashMap();
        defaultValue.put(Boolean.TYPE, 3);
        defaultValue.put(Byte.TYPE, 3);
        defaultValue.put(Character.TYPE, 3);
        defaultValue.put(Double.TYPE, 14);
        defaultValue.put(Float.TYPE, 11);
        defaultValue.put(Integer.TYPE, 3);
        defaultValue.put(Long.TYPE, 9);
        defaultValue.put(Short.TYPE, 3);
        primitivesClassAndWrapper = new HashSet();
        primitivesClassAndWrapper.addAll(wrappers.keySet());
        primitivesClassAndWrapper.addAll(wrappers.values());
        targetDir = null;
        String targetDirStr = System.getProperty(ASM_DUMP_TARGET_DIR);
        if (targetDirStr != null) {
            targetDir = new File(targetDirStr);
            targetDir.mkdirs();
        }
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class<?> rawType;
        private final Type[] types;

        public ParameterizedTypeImpl(Class<?> rawType, Type[] types) {
            this.rawType = rawType;
            this.types = types;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.types;
        }

        public String toString() {
            return "ParameterizedTypeImpl{rawType=" + this.rawType + ", types=" + Arrays.toString(this.types) + '}';
        }
    }
}

