/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sfm.tuples.Tuple2;

public class TypeHelper {
    private static final Map<Class<?>, Class<?>> wrappers = new HashMap();

    public static <T> Class<T> toClass(Type target) {
        if (target instanceof Class) {
            return (Class)target;
        }
        if (target instanceof ParameterizedType) {
            return (Class)((ParameterizedType)target).getRawType();
        }
        if (target instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)target).getBounds();
            return (Class)bounds[0];
        }
        throw new UnsupportedOperationException("Cannot extract class from type " + target);
    }

    public static <T> Map<TypeVariable<?>, Type> getTypesMap(Type targetType, Class<T> targetClass) {
        Map<TypeVariable<?>, Type> genericTypes = Collections.emptyMap();
        if (targetType instanceof ParameterizedType) {
            TypeVariable<Class<T>>[] typeParameters = targetClass.getTypeParameters();
            Type[] actualTypeArguments = ((ParameterizedType)targetType).getActualTypeArguments();
            genericTypes = new HashMap();
            for (int i = 0; i < typeParameters.length; ++i) {
                TypeVariable<Class<T>> typeParameter = typeParameters[i];
                Type typeArgument = actualTypeArguments[i];
                genericTypes.put(typeParameter, typeArgument);
            }
        }
        return genericTypes;
    }

    public static boolean isPrimitive(Type type) {
        return TypeHelper.toClass(type).isPrimitive();
    }

    public static Class<?> wrap(Class<?> target) {
        if (target.isPrimitive()) {
            return wrappers.get(target);
        }
        return target;
    }

    public static Class<?> wrap(Type type) {
        return TypeHelper.wrap(TypeHelper.toClass(type));
    }

    public static boolean areCompatible(Class<?> target, Class<?> source) {
        Class<?> wrapTarget = TypeHelper.wrap(target);
        Class<?> wrapSource = TypeHelper.wrap(source);
        return wrapTarget.isAssignableFrom(wrapSource);
    }

    public static boolean isNumber(Type target) {
        return Number.class.isAssignableFrom(TypeHelper.wrap(TypeHelper.toClass(target)));
    }

    public static boolean isArray(Type outType) {
        return TypeHelper.toClass(outType).isArray();
    }

    public static Type getComponentTypeOfListOrArray(Type outType) {
        Class target = TypeHelper.toClass(outType);
        if (target.isArray()) {
            return TypeHelper.toClass(outType).getComponentType();
        }
        Type[] parameterTypes = TypeHelper.getGenericParameterForClass(outType, Collection.class);
        if (parameterTypes != null) {
            return parameterTypes[0];
        }
        return null;
    }

    public static Tuple2<Type, Type> getKeyValueTypeOfMap(Type outType) {
        Type[] parameterTypes = TypeHelper.getGenericParameterForClass(outType, Map.class);
        if (parameterTypes != null) {
            return new Tuple2<Type, Type>(parameterTypes[0], parameterTypes[1]);
        }
        return null;
    }

    private static Type getGenericInterface(Type t, Class<?> i) {
        if (TypeHelper.areEquals(t, i)) {
            return t;
        }
        if (t instanceof Class) {
            for (Type it : ((Class)t).getGenericInterfaces()) {
                if (!TypeHelper.isAssignable(i, it)) continue;
                return it;
            }
        } else if (t instanceof ParameterizedType) {
            return TypeHelper.getGenericInterface(((ParameterizedType)t).getRawType(), i);
        }
        return null;
    }

    private static Type getGenericSuperType(Type t) {
        if (t instanceof Class) {
            return ((Class)t).getGenericSuperclass();
        }
        if (t instanceof ParameterizedType) {
            return TypeHelper.getGenericSuperType(((ParameterizedType)t).getRawType());
        }
        return null;
    }

    public static Type[] getParamTypesForInterface(Class<?> target, Class<?> inter) {
        Type[] genericInterfaces;
        if (target == null) {
            return null;
        }
        for (Type t : genericInterfaces = target.getGenericInterfaces()) {
            Type[] readerClass;
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                if (!pt.getRawType().equals(inter)) continue;
                return pt.getActualTypeArguments();
            }
            if (!(t instanceof Class) || (readerClass = TypeHelper.getParamTypesForInterface((Class)t, inter)) == null) continue;
            return readerClass;
        }
        return TypeHelper.getParamTypesForInterface(target.getSuperclass(), inter);
    }

    public static boolean isClass(Type outType, Class<?> class1) {
        return TypeHelper.toClass(outType).equals(class1);
    }

    public static boolean isAssignable(Class<?> class1, Type from) {
        return class1.isAssignableFrom(TypeHelper.toClass(from));
    }

    public static boolean isJavaLang(Type target) {
        Class clazz = TypeHelper.toClass(target);
        return clazz.isPrimitive() || clazz.getPackage().getName().equals("java.lang");
    }

    public static boolean isEnum(Type target) {
        Class clazz = TypeHelper.toClass(target);
        return clazz.isEnum();
    }

    public static Class<?> toBoxedClass(Class<?> target) {
        if (target.isPrimitive()) {
            return wrappers.get(target);
        }
        return target;
    }

    public static boolean areEquals(Type target, Class<?> clazz) {
        return clazz.equals(TypeHelper.toClass(target));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type[] getGenericParameterForClass(Type type, Class<?> interfaceClass) {
        Type[] types;
        if (!TypeHelper.isAssignable(interfaceClass, type)) throw new IllegalArgumentException("type " + type + " does not implement/extends " + interfaceClass);
        Type genericInterface = TypeHelper.getGenericInterface(type, interfaceClass);
        if (genericInterface != null) {
            if (!(genericInterface instanceof ParameterizedType)) throw new IllegalStateException("type " + type + " is not a ParameterizedType");
            types = ((ParameterizedType)genericInterface).getActualTypeArguments();
        } else {
            types = TypeHelper.getGenericParameterForClass(TypeHelper.getGenericSuperType(type), interfaceClass);
        }
        TypeHelper.resolveTypeVariables(type, types);
        return types;
    }

    private static void resolveTypeVariables(Type source, Type[] types) {
        for (int i = 0; i < types.length; ++i) {
            Type t = types[i];
            if (!(t instanceof TypeVariable)) continue;
            types[i] = TypeHelper.resolveTypeVariable(source, (TypeVariable)t);
        }
    }

    public static Type resolveTypeVariable(Type type, TypeVariable t) {
        TypeVariable<Class<T>>[] typeParameters = TypeHelper.toClass(type).getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable typeVariable = typeParameters[i];
            if (!typeVariable.getName().equals(t.getName())) continue;
            return ((ParameterizedType)type).getActualTypeArguments()[i];
        }
        return type;
    }

    static {
        wrappers.put(Boolean.TYPE, Boolean.class);
        wrappers.put(Byte.TYPE, Byte.class);
        wrappers.put(Short.TYPE, Short.class);
        wrappers.put(Character.TYPE, Character.class);
        wrappers.put(Integer.TYPE, Integer.class);
        wrappers.put(Long.TYPE, Long.class);
        wrappers.put(Float.TYPE, Float.class);
        wrappers.put(Double.TYPE, Double.class);
    }
}

