/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sfm.reflect.FastTupleClassMeta;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.InstantiatorFactory;
import org.sfm.reflect.ObjectGetterFactory;
import org.sfm.reflect.ObjectSetterFactory;
import org.sfm.reflect.ReflectionInstantiatorDefinitionFactory;
import org.sfm.reflect.Setter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.asm.AsmFactory;
import org.sfm.reflect.asm.AsmHelper;
import org.sfm.reflect.asm.AsmInstantiatorDefinitionFactory;
import org.sfm.reflect.meta.AliasProvider;
import org.sfm.reflect.meta.AliasProviderFactory;
import org.sfm.reflect.meta.ArrayClassMeta;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.DirectClassMeta;
import org.sfm.reflect.meta.MapClassMeta;
import org.sfm.reflect.meta.ObjectClassMeta;
import org.sfm.reflect.meta.OptionalClassMeta;
import org.sfm.reflect.meta.TupleClassMeta;
import org.sfm.tuples.Tuple2;
import org.sfm.tuples.Tuples;
import org.sfm.utils.Asserts;

public class ReflectionService {
    private final ObjectSetterFactory objectSetterFactory;
    private final ObjectGetterFactory objectGetterFactory;
    private final InstantiatorFactory instantiatorFactory;
    private final AsmFactory asmFactory;
    private final AliasProvider aliasProvider;
    private final boolean asmPresent;
    private final boolean asmActivated;
    private final ConcurrentMap<Type, ClassMeta<?>> metaCache = new ConcurrentHashMap();
    private static final AsmFactory _asmFactory = new AsmFactory(Thread.currentThread().getContextClassLoader());

    public ReflectionService(boolean asmPresent, boolean asmActivated, AsmFactory asmFactory) {
        this.asmPresent = asmPresent;
        this.asmActivated = asmActivated && asmPresent;
        this.asmFactory = asmActivated ? asmFactory : null;
        this.objectSetterFactory = new ObjectSetterFactory(asmFactory);
        this.objectGetterFactory = new ObjectGetterFactory(asmFactory);
        this.instantiatorFactory = new InstantiatorFactory(asmFactory);
        this.aliasProvider = AliasProviderFactory.getAliasProvider();
    }

    public ObjectSetterFactory getObjectSetterFactory() {
        return this.objectSetterFactory;
    }

    public InstantiatorFactory getInstantiatorFactory() {
        return this.instantiatorFactory;
    }

    public boolean isAsmPresent() {
        return this.asmPresent;
    }

    public boolean isAsmActivated() {
        return this.asmActivated;
    }

    public AsmFactory getAsmFactory() {
        return this.asmFactory;
    }

    public <T> ClassMeta<T> getClassMeta(Type target) {
        Asserts.requireNonNull("target", target);
        ClassMeta<T> meta = (ClassMeta<T>)this.metaCache.get(target);
        if (meta == null) {
            meta = this.newClassMeta(target);
            Asserts.requireNonNull("meta", meta);
            this.metaCache.putIfAbsent(target, meta);
        }
        return meta;
    }

    private <T> ClassMeta<T> newClassMeta(Type target) {
        Class clazz = TypeHelper.toClass(target);
        if (Map.class.isAssignableFrom(clazz)) {
            return this.newMapMeta(target);
        }
        if (List.class.isAssignableFrom(clazz)) {
            return this.newArrayListMeta(target);
        }
        if (clazz.isArray()) {
            return this.newArrayMeta(clazz);
        }
        if (Optional.class.isAssignableFrom(clazz)) {
            return new OptionalClassMeta(target, this);
        }
        if (Tuples.isTuple(target)) {
            return new TupleClassMeta(target, this);
        }
        if (this.isFastTuple(clazz)) {
            return new FastTupleClassMeta(target, this);
        }
        if (this.isDirectType(target)) {
            return new DirectClassMeta(target, this);
        }
        return new ObjectClassMeta(target, this);
    }

    private <K, V> ClassMeta<Map<K, V>> newMapMeta(Type type) {
        Tuple2<Type, Type> types = TypeHelper.getKeyValueTypeOfMap(type);
        return new MapClassMeta(type, types.first(), types.second(), this);
    }

    private <T, E> ClassMeta<T> newArrayMeta(Class<T> clazz) {
        return new ArrayClassMeta(clazz, clazz.getComponentType(), this);
    }

    private <T, E> ClassMeta<T> newArrayListMeta(Type type) {
        return new ArrayClassMeta(type, TypeHelper.getComponentTypeOfListOrArray(type), this);
    }

    private <T> boolean isFastTuple(Class<T> clazz) {
        Class<T> superClass = clazz.getSuperclass();
        return superClass != null && "com.boundary.tuple.FastTuple".equals(superClass.getName());
    }

    private boolean isDirectType(Type target) {
        return TypeHelper.isJavaLang(target) || TypeHelper.isEnum(target) || TypeHelper.areEquals(target, Date.class);
    }

    public String getColumnName(Method method) {
        return this.aliasProvider.getAliasForMethod(method);
    }

    public String getColumnName(Field field) {
        return this.aliasProvider.getAliasForField(field);
    }

    public List<InstantiatorDefinition> extractConstructors(Type target) throws IOException {
        List<InstantiatorDefinition> list;
        if (this.isAsmPresent()) {
            try {
                list = AsmInstantiatorDefinitionFactory.extractDefinitions(target);
            }
            catch (IOException e) {
                list = ReflectionInstantiatorDefinitionFactory.extractDefinitions(target);
            }
        } else {
            list = ReflectionInstantiatorDefinitionFactory.extractDefinitions(target);
        }
        Collections.sort(list);
        return list;
    }

    public static ReflectionService newInstance() {
        return ReflectionService.newInstance(false, true);
    }

    public static ReflectionService newInstance(boolean disableAsm, boolean useAsmGeneration) {
        boolean asmPresent = AsmHelper.isAsmPresent() && !disableAsm;
        boolean hasClassLoaderIncapacity = ReflectionService.cannotSeeSetterFromContextClassLoader();
        if (hasClassLoaderIncapacity) {
            useAsmGeneration = false;
        }
        return new ReflectionService(asmPresent, useAsmGeneration, asmPresent && useAsmGeneration ? _asmFactory : null);
    }

    public static ReflectionService disableAsm() {
        return ReflectionService.newInstance(true, false);
    }

    private static boolean cannotSeeSetterFromContextClassLoader() {
        try {
            Class.forName(Setter.class.getName(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public ObjectGetterFactory getObjectGetterFactory() {
        return this.objectGetterFactory;
    }
}

