/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.sfm.reflect.GetterHelper;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.MethodPropertyMeta;
import org.sfm.reflect.meta.ObjectClassMeta;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.utils.ErrorHelper;

public class FastTupleClassMeta<T>
implements ClassMeta<T> {
    private final ClassMeta<T> delegate;
    private final String[] headers;
    private final List<InstantiatorDefinition> instantiatorDefinitions;

    public FastTupleClassMeta(Type target, ReflectionService reflectionService) {
        try {
            Class clazz = TypeHelper.toClass(target);
            this.instantiatorDefinitions = new ArrayList<InstantiatorDefinition>();
            this.instantiatorDefinitions.add(new InstantiatorDefinition(clazz.getConstructor(new Class[0]), new Parameter[0]));
            ArrayList properties = this.getPropertyMetas(clazz, reflectionService);
            this.delegate = new ObjectClassMeta(target, this.instantiatorDefinitions, new ArrayList(), properties, reflectionService);
            this.headers = this.getHeaders(clazz, properties);
        }
        catch (NoSuchMethodException e) {
            ErrorHelper.rethrow(e);
            throw new IllegalStateException();
        }
    }

    private String[] getHeaders(Class<?> clazz, List<PropertyMeta<T, ?>> properties) {
        try {
            clazz.getDeclaredField("unsafe");
            return null;
        }
        catch (NoSuchFieldException e) {
            Field[] declaredFields = clazz.getDeclaredFields();
            String[] headers = new String[properties.size()];
            for (int i = 0; i < declaredFields.length; ++i) {
                String name = declaredFields[i].getName();
                if (!this.isPresent(properties, name)) continue;
                headers[i] = name;
            }
            return headers;
        }
    }

    private boolean isPresent(List<PropertyMeta<T, ?>> properties, String name) {
        for (PropertyMeta<T, ?> pm : properties) {
            if (!pm.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<PropertyMeta<T, ?>> getPropertyMetas(Class<T> clazz, ReflectionService reflectionService) throws NoSuchMethodException {
        ArrayList propertyMetas = new ArrayList();
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getParameterTypes().length != 0 || !GetterHelper.methodModifiersMatches(m.getModifiers())) continue;
            String field = m.getName();
            Method setter = clazz.getDeclaredMethod(field, m.getReturnType());
            MethodPropertyMeta propertyMeta = this.newPropertyMethod(field, m, setter, reflectionService);
            propertyMetas.add(propertyMeta);
        }
        return propertyMetas;
    }

    private <P> MethodPropertyMeta<T, P> newPropertyMethod(String field, Method getter, Method setter, ReflectionService reflectionService) {
        return new MethodPropertyMeta(field, reflectionService, setter, getter, getter.getGenericReturnType());
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.delegate.getReflectionService();
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return this.delegate.newPropertyFinder();
    }

    @Override
    public Type getType() {
        return this.delegate.getType();
    }

    @Override
    public String[] generateHeaders() {
        if (this.headers == null) {
            throw new UnsupportedOperationException("Cannot generate headers on directMemory tuple");
        }
        return this.headers;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return this.instantiatorDefinitions;
    }
}

