/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.poi.impl;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;
import org.sfm.csv.CsvColumnKey;
import org.sfm.map.ColumnDefinition;
import org.sfm.map.GetterFactory;
import org.sfm.map.impl.getter.joda.JodaTimeGetterFactory;
import org.sfm.map.impl.getter.time.JavaTimeGetterFactory;
import org.sfm.poi.impl.PoiBooleanGetter;
import org.sfm.poi.impl.PoiByteGetter;
import org.sfm.poi.impl.PoiCharacterGetter;
import org.sfm.poi.impl.PoiDateGetter;
import org.sfm.poi.impl.PoiDoubleGetter;
import org.sfm.poi.impl.PoiEnumGetter;
import org.sfm.poi.impl.PoiFloatGetter;
import org.sfm.poi.impl.PoiIntegerGetter;
import org.sfm.poi.impl.PoiLongGetter;
import org.sfm.poi.impl.PoiShortGetter;
import org.sfm.poi.impl.PoiStringGetter;
import org.sfm.reflect.Getter;
import org.sfm.reflect.TypeHelper;

public class RowGetterFactory
implements GetterFactory<Row, CsvColumnKey> {
    private static final Map<Class<?>, GetterFactory<Row, CsvColumnKey>> getterFactories = new HashMap();
    private static final JodaTimeGetterFactory<Row, CsvColumnKey> jodaTimeGetterFactory;

    @Override
    public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
        Class targetClass = TypeHelper.toClass(target);
        GetterFactory<Row, CsvColumnKey> rowGetterFactory = getterFactories.get(targetClass);
        if (rowGetterFactory != null) {
            return rowGetterFactory.newGetter(target, key, columnDefinition);
        }
        if (TypeHelper.isEnum(target)) {
            return new PoiEnumGetter(key.getIndex(), TypeHelper.toClass(target));
        }
        Getter getter = jodaTimeGetterFactory.newGetter(target, key, columnDefinition);
        if (getter != null) {
            return getter;
        }
        return null;
    }

    static {
        getterFactories.put(String.class, new GetterFactory<Row, CsvColumnKey>(){

            @Override
            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiStringGetter(key.getIndex());
            }
        });
        getterFactories.put(Date.class, new GetterFactory<Row, CsvColumnKey>(){

            @Override
            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiDateGetter(key.getIndex());
            }
        });
        getterFactories.put(Byte.class, new GetterFactory<Row, CsvColumnKey>(){

            @Override
            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiByteGetter(key.getIndex());
            }
        });
        getterFactories.put(Character.class, new GetterFactory<Row, CsvColumnKey>(){

            @Override
            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiCharacterGetter(key.getIndex());
            }
        });
        getterFactories.put(Short.class, new GetterFactory<Row, CsvColumnKey>(){

            @Override
            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiShortGetter(key.getIndex());
            }
        });
        getterFactories.put(Integer.class, new GetterFactory<Row, CsvColumnKey>(){

            @Override
            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiIntegerGetter(key.getIndex());
            }
        });
        getterFactories.put(Long.class, new GetterFactory<Row, CsvColumnKey>(){

            @Override
            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiLongGetter(key.getIndex());
            }
        });
        getterFactories.put(Float.class, new GetterFactory<Row, CsvColumnKey>(){

            @Override
            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiFloatGetter(key.getIndex());
            }
        });
        getterFactories.put(Double.class, new GetterFactory<Row, CsvColumnKey>(){

            @Override
            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiDoubleGetter(key.getIndex());
            }
        });
        getterFactories.put(Boolean.class, new GetterFactory<Row, CsvColumnKey>(){

            @Override
            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiBooleanGetter(key.getIndex());
            }
        });
        getterFactories.put(Byte.TYPE, getterFactories.get(Byte.class));
        getterFactories.put(Character.TYPE, getterFactories.get(Character.class));
        getterFactories.put(Short.TYPE, getterFactories.get(Short.class));
        getterFactories.put(Integer.TYPE, getterFactories.get(Integer.class));
        getterFactories.put(Long.TYPE, getterFactories.get(Long.class));
        getterFactories.put(Float.TYPE, getterFactories.get(Float.class));
        getterFactories.put(Double.TYPE, getterFactories.get(Double.class));
        getterFactories.put(Boolean.TYPE, getterFactories.get(Boolean.class));
        JavaTimeGetterFactory<Row, CsvColumnKey> javaTimeGetterFactory = new JavaTimeGetterFactory<Row, CsvColumnKey>(getterFactories.get(Date.class));
        getterFactories.put(LocalDate.class, javaTimeGetterFactory);
        getterFactories.put(LocalDateTime.class, javaTimeGetterFactory);
        getterFactories.put(LocalTime.class, javaTimeGetterFactory);
        getterFactories.put(OffsetDateTime.class, javaTimeGetterFactory);
        getterFactories.put(OffsetTime.class, javaTimeGetterFactory);
        getterFactories.put(ZonedDateTime.class, javaTimeGetterFactory);
        getterFactories.put(Instant.class, javaTimeGetterFactory);
        getterFactories.put(Year.class, javaTimeGetterFactory);
        getterFactories.put(YearMonth.class, javaTimeGetterFactory);
        jodaTimeGetterFactory = new JodaTimeGetterFactory<Row, CsvColumnKey>(getterFactories.get(Date.class));
    }
}

