/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl.getter;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.sfm.reflect.Getter;

public final class ArrayResultSetGetter<E>
implements Getter<ResultSet, E[]> {
    private final int column;
    private final Class<E> elementType;
    private final Getter<ResultSet, E> elementGetter;

    public ArrayResultSetGetter(int column, Class<E> elementType, Getter<ResultSet, E> elementGetter) {
        this.column = column;
        this.elementType = elementType;
        this.elementGetter = elementGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E[] get(ResultSet target) throws Exception {
        java.sql.Array array = target.getArray(this.column);
        ArrayList<E> list = new ArrayList<E>();
        try (ResultSet rs = array.getResultSet();){
            while (rs.next()) {
                list.add(this.elementGetter.get(rs));
            }
        }
        Object[] eltArray = (Object[])Array.newInstance(this.elementType, list.size());
        return list.toArray(eltArray);
    }

    public String toString() {
        return "ArrayResultSetGetter{column=" + this.column + ", elementGetter=" + this.elementGetter + '}';
    }
}

