/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.parser;

import org.sfm.csv.parser.AbstractCsvCharConsumer;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.csv.parser.CharBuffer;

public final class ConfigurableCsvCharConsumer
extends AbstractCsvCharConsumer {
    private final char separatorChar;
    private final char quoteChar;

    public ConfigurableCsvCharConsumer(CharBuffer csvBuffer, char separatorChar, char quoteChar) {
        super(csvBuffer);
        this.separatorChar = separatorChar;
        this.quoteChar = quoteChar;
    }

    @Override
    protected void consumeOneChar(char character, int index, CellConsumer cellConsumer) {
        if (character == this.separatorChar) {
            this.newCellIfNotInQuote(index, cellConsumer);
        } else if (character == '\n') {
            this.handleEndOfLineLF(index, cellConsumer);
        } else {
            if (character == '\r') {
                this.handleEndOfLineCR(index, cellConsumer);
                return;
            }
            if (character == this.quoteChar) {
                this.quote(index);
            }
        }
        this.turnOffCrFlag();
    }

    @Override
    public boolean nextRow(CellConsumer cellConsumer) {
        int bufferLength = this.csvBuffer.getBufferLength();
        for (int index = this._currentIndex; index < bufferLength; ++index) {
            char character = this.csvBuffer.getChar(index);
            if (character == this.separatorChar) {
                this.newCellIfNotInQuote(index, cellConsumer);
            } else if (character == '\n') {
                if (this.handleEndOfLineLF(index, cellConsumer)) {
                    this._currentIndex = index + 1;
                    this.turnOffCrFlag();
                    return true;
                }
            } else if (character == '\r') {
                if (this.handleEndOfLineCR(index, cellConsumer)) {
                    this._currentIndex = index + 1;
                    return true;
                }
            } else if (character == this.quoteChar) {
                this.quote(index);
            }
            this.turnOffCrFlag();
        }
        this._currentIndex = bufferLength;
        return false;
    }

    @Override
    public char quoteChar() {
        return this.quoteChar;
    }
}

